/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.BlobRestoreRange;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BlobRestoreParameters
implements JsonSerializable<BlobRestoreParameters> {
    private OffsetDateTime timeToRestore;
    private List<BlobRestoreRange> blobRanges;
    private static final ClientLogger LOGGER = new ClientLogger(BlobRestoreParameters.class);

    public OffsetDateTime timeToRestore() {
        return this.timeToRestore;
    }

    public BlobRestoreParameters withTimeToRestore(OffsetDateTime timeToRestore) {
        this.timeToRestore = timeToRestore;
        return this;
    }

    public List<BlobRestoreRange> blobRanges() {
        return this.blobRanges;
    }

    public BlobRestoreParameters withBlobRanges(List<BlobRestoreRange> blobRanges) {
        this.blobRanges = blobRanges;
        return this;
    }

    public void validate() {
        if (this.timeToRestore() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeToRestore in model BlobRestoreParameters"));
        }
        if (this.blobRanges() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property blobRanges in model BlobRestoreParameters"));
        }
        this.blobRanges().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeToRestore", this.timeToRestore == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timeToRestore));
        jsonWriter.writeArrayField("blobRanges", this.blobRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BlobRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BlobRestoreParameters)jsonReader.readObject(reader -> {
            BlobRestoreParameters deserializedBlobRestoreParameters = new BlobRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeToRestore".equals(fieldName)) {
                    deserializedBlobRestoreParameters.timeToRestore = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("blobRanges".equals(fieldName)) {
                    List blobRanges;
                    deserializedBlobRestoreParameters.blobRanges = blobRanges = reader.readArray(reader1 -> BlobRestoreRange.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobRestoreParameters;
        });
    }
}

