/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.QueueProperties;
import java.io.IOException;
import java.util.Map;

public final class StorageQueueInner
extends ProxyResource {
    private QueueProperties innerQueueProperties;
    private String type;
    private String name;
    private String id;

    private QueueProperties innerQueueProperties() {
        return this.innerQueueProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Map<String, String> metadata() {
        return this.innerQueueProperties() == null ? null : this.innerQueueProperties().metadata();
    }

    public StorageQueueInner withMetadata(Map<String, String> metadata) {
        if (this.innerQueueProperties() == null) {
            this.innerQueueProperties = new QueueProperties();
        }
        this.innerQueueProperties().withMetadata(metadata);
        return this;
    }

    public Integer approximateMessageCount() {
        return this.innerQueueProperties() == null ? null : this.innerQueueProperties().approximateMessageCount();
    }

    public void validate() {
        if (this.innerQueueProperties() != null) {
            this.innerQueueProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerQueueProperties);
        return jsonWriter.writeEndObject();
    }

    public static StorageQueueInner fromJson(JsonReader jsonReader) throws IOException {
        return (StorageQueueInner)((Object)jsonReader.readObject(reader -> {
            StorageQueueInner deserializedStorageQueueInner = new StorageQueueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageQueueInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageQueueInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageQueueInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageQueueInner.innerQueueProperties = QueueProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageQueueInner;
        }));
    }
}

