/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ManagementPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagementPolicyProperties
implements JsonSerializable<ManagementPolicyProperties> {
    private OffsetDateTime lastModifiedTime;
    private ManagementPolicySchema policy;
    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicyProperties.class);

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ManagementPolicySchema policy() {
        return this.policy;
    }

    public ManagementPolicyProperties withPolicy(ManagementPolicySchema policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.policy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policy in model ManagementPolicyProperties"));
        }
        this.policy().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementPolicyProperties)jsonReader.readObject(reader -> {
            ManagementPolicyProperties deserializedManagementPolicyProperties = new ManagementPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedManagementPolicyProperties.policy = ManagementPolicySchema.fromJson(reader);
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedManagementPolicyProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyProperties;
        });
    }
}

