/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanError;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanState;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanTriggerType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class VulnerabilityAssessmentScanRecordProperties
implements JsonSerializable<VulnerabilityAssessmentScanRecordProperties> {
    private String scanId;
    private VulnerabilityAssessmentScanTriggerType triggerType;
    private VulnerabilityAssessmentScanState state;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<VulnerabilityAssessmentScanError> errors;
    private String storageContainerPath;
    private Integer numberOfFailedSecurityChecks;

    public String scanId() {
        return this.scanId;
    }

    public VulnerabilityAssessmentScanTriggerType triggerType() {
        return this.triggerType;
    }

    public VulnerabilityAssessmentScanState state() {
        return this.state;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public List<VulnerabilityAssessmentScanError> errors() {
        return this.errors;
    }

    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    public Integer numberOfFailedSecurityChecks() {
        return this.numberOfFailedSecurityChecks;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static VulnerabilityAssessmentScanRecordProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VulnerabilityAssessmentScanRecordProperties)jsonReader.readObject(reader -> {
            VulnerabilityAssessmentScanRecordProperties deserializedVulnerabilityAssessmentScanRecordProperties = new VulnerabilityAssessmentScanRecordProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scanId".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.scanId = reader.getString();
                    continue;
                }
                if ("triggerType".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.triggerType = VulnerabilityAssessmentScanTriggerType.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.state = VulnerabilityAssessmentScanState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedVulnerabilityAssessmentScanRecordProperties.errors = errors = reader.readArray(reader1 -> VulnerabilityAssessmentScanError.fromJson(reader1));
                    continue;
                }
                if ("storageContainerPath".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.storageContainerPath = reader.getString();
                    continue;
                }
                if ("numberOfFailedSecurityChecks".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.numberOfFailedSecurityChecks = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVulnerabilityAssessmentScanRecordProperties;
        });
    }
}

