/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ServerConnectionPolicyProperties;
import com.azure.resourcemanager.sql.models.ServerConnectionType;
import java.io.IOException;

public final class ServerConnectionPolicyInner
extends ProxyResource {
    private String location;
    private String kind;
    private ServerConnectionPolicyProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String location() {
        return this.location;
    }

    public String kind() {
        return this.kind;
    }

    private ServerConnectionPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ServerConnectionType connectionType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionType();
    }

    public ServerConnectionPolicyInner withConnectionType(ServerConnectionType connectionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerConnectionPolicyProperties();
        }
        this.innerProperties().withConnectionType(connectionType);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ServerConnectionPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerConnectionPolicyInner)((Object)jsonReader.readObject(reader -> {
            ServerConnectionPolicyInner deserializedServerConnectionPolicyInner = new ServerConnectionPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.location = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.kind = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.innerProperties = ServerConnectionPolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerConnectionPolicyInner;
        }));
    }
}

