/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.MaintenanceWindowTimeRange;
import java.io.IOException;
import java.util.List;

public final class MaintenanceWindowOptionsProperties
implements JsonSerializable<MaintenanceWindowOptionsProperties> {
    private Boolean isEnabled;
    private List<MaintenanceWindowTimeRange> maintenanceWindowCycles;
    private Integer minDurationInMinutes;
    private Integer defaultDurationInMinutes;
    private Integer minCycles;
    private Integer timeGranularityInMinutes;
    private Boolean allowMultipleMaintenanceWindowsPerCycle;

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public MaintenanceWindowOptionsProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public List<MaintenanceWindowTimeRange> maintenanceWindowCycles() {
        return this.maintenanceWindowCycles;
    }

    public MaintenanceWindowOptionsProperties withMaintenanceWindowCycles(List<MaintenanceWindowTimeRange> maintenanceWindowCycles) {
        this.maintenanceWindowCycles = maintenanceWindowCycles;
        return this;
    }

    public Integer minDurationInMinutes() {
        return this.minDurationInMinutes;
    }

    public MaintenanceWindowOptionsProperties withMinDurationInMinutes(Integer minDurationInMinutes) {
        this.minDurationInMinutes = minDurationInMinutes;
        return this;
    }

    public Integer defaultDurationInMinutes() {
        return this.defaultDurationInMinutes;
    }

    public MaintenanceWindowOptionsProperties withDefaultDurationInMinutes(Integer defaultDurationInMinutes) {
        this.defaultDurationInMinutes = defaultDurationInMinutes;
        return this;
    }

    public Integer minCycles() {
        return this.minCycles;
    }

    public MaintenanceWindowOptionsProperties withMinCycles(Integer minCycles) {
        this.minCycles = minCycles;
        return this;
    }

    public Integer timeGranularityInMinutes() {
        return this.timeGranularityInMinutes;
    }

    public MaintenanceWindowOptionsProperties withTimeGranularityInMinutes(Integer timeGranularityInMinutes) {
        this.timeGranularityInMinutes = timeGranularityInMinutes;
        return this;
    }

    public Boolean allowMultipleMaintenanceWindowsPerCycle() {
        return this.allowMultipleMaintenanceWindowsPerCycle;
    }

    public MaintenanceWindowOptionsProperties withAllowMultipleMaintenanceWindowsPerCycle(Boolean allowMultipleMaintenanceWindowsPerCycle) {
        this.allowMultipleMaintenanceWindowsPerCycle = allowMultipleMaintenanceWindowsPerCycle;
        return this;
    }

    public void validate() {
        if (this.maintenanceWindowCycles() != null) {
            this.maintenanceWindowCycles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeArrayField("maintenanceWindowCycles", this.maintenanceWindowCycles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("minDurationInMinutes", (Number)this.minDurationInMinutes);
        jsonWriter.writeNumberField("defaultDurationInMinutes", (Number)this.defaultDurationInMinutes);
        jsonWriter.writeNumberField("minCycles", (Number)this.minCycles);
        jsonWriter.writeNumberField("timeGranularityInMinutes", (Number)this.timeGranularityInMinutes);
        jsonWriter.writeBooleanField("allowMultipleMaintenanceWindowsPerCycle", this.allowMultipleMaintenanceWindowsPerCycle);
        return jsonWriter.writeEndObject();
    }

    public static MaintenanceWindowOptionsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MaintenanceWindowOptionsProperties)jsonReader.readObject(reader -> {
            MaintenanceWindowOptionsProperties deserializedMaintenanceWindowOptionsProperties = new MaintenanceWindowOptionsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isEnabled".equals(fieldName)) {
                    deserializedMaintenanceWindowOptionsProperties.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maintenanceWindowCycles".equals(fieldName)) {
                    List maintenanceWindowCycles;
                    deserializedMaintenanceWindowOptionsProperties.maintenanceWindowCycles = maintenanceWindowCycles = reader.readArray(reader1 -> MaintenanceWindowTimeRange.fromJson(reader1));
                    continue;
                }
                if ("minDurationInMinutes".equals(fieldName)) {
                    deserializedMaintenanceWindowOptionsProperties.minDurationInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultDurationInMinutes".equals(fieldName)) {
                    deserializedMaintenanceWindowOptionsProperties.defaultDurationInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minCycles".equals(fieldName)) {
                    deserializedMaintenanceWindowOptionsProperties.minCycles = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("timeGranularityInMinutes".equals(fieldName)) {
                    deserializedMaintenanceWindowOptionsProperties.timeGranularityInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowMultipleMaintenanceWindowsPerCycle".equals(fieldName)) {
                    deserializedMaintenanceWindowOptionsProperties.allowMultipleMaintenanceWindowsPerCycle = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMaintenanceWindowOptionsProperties;
        });
    }
}

