/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.JobSchedule;
import java.io.IOException;

public final class JobProperties
implements JsonSerializable<JobProperties> {
    private String description;
    private Integer version;
    private JobSchedule schedule;

    public String description() {
        return this.description;
    }

    public JobProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public JobSchedule schedule() {
        return this.schedule;
    }

    public JobProperties withSchedule(JobSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public void validate() {
        if (this.schedule() != null) {
            this.schedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        return jsonWriter.writeEndObject();
    }

    public static JobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobProperties)jsonReader.readObject(reader -> {
            JobProperties deserializedJobProperties = new JobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedJobProperties.description = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedJobProperties.version = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedJobProperties.schedule = JobSchedule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobProperties;
        });
    }
}

