/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import java.io.IOException;

public final class DatabaseVulnerabilityAssessmentProperties
implements JsonSerializable<DatabaseVulnerabilityAssessmentProperties> {
    private String storageContainerPath;
    private String storageContainerSasKey;
    private String storageAccountAccessKey;
    private VulnerabilityAssessmentRecurringScansProperties recurringScans;

    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    public DatabaseVulnerabilityAssessmentProperties withStorageContainerPath(String storageContainerPath) {
        this.storageContainerPath = storageContainerPath;
        return this;
    }

    public String storageContainerSasKey() {
        return this.storageContainerSasKey;
    }

    public DatabaseVulnerabilityAssessmentProperties withStorageContainerSasKey(String storageContainerSasKey) {
        this.storageContainerSasKey = storageContainerSasKey;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public DatabaseVulnerabilityAssessmentProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.recurringScans;
    }

    public DatabaseVulnerabilityAssessmentProperties withRecurringScans(VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        this.recurringScans = recurringScans;
        return this;
    }

    public void validate() {
        if (this.recurringScans() != null) {
            this.recurringScans().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageContainerPath", this.storageContainerPath);
        jsonWriter.writeStringField("storageContainerSasKey", this.storageContainerSasKey);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeJsonField("recurringScans", (JsonSerializable)this.recurringScans);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseVulnerabilityAssessmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseVulnerabilityAssessmentProperties)jsonReader.readObject(reader -> {
            DatabaseVulnerabilityAssessmentProperties deserializedDatabaseVulnerabilityAssessmentProperties = new DatabaseVulnerabilityAssessmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageContainerPath".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentProperties.storageContainerPath = reader.getString();
                    continue;
                }
                if ("storageContainerSasKey".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentProperties.storageContainerSasKey = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("recurringScans".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentProperties.recurringScans = VulnerabilityAssessmentRecurringScansProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseVulnerabilityAssessmentProperties;
        });
    }
}

