/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import java.io.IOException;

public final class MinCapacityCapability
implements JsonSerializable<MinCapacityCapability> {
    private Double value;
    private CapabilityStatus status;
    private String reason;

    public Double value() {
        return this.value;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public MinCapacityCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static MinCapacityCapability fromJson(JsonReader jsonReader) throws IOException {
        return (MinCapacityCapability)jsonReader.readObject(reader -> {
            MinCapacityCapability deserializedMinCapacityCapability = new MinCapacityCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedMinCapacityCapability.value = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMinCapacityCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedMinCapacityCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMinCapacityCapability;
        });
    }
}

