/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DataMaskingState;
import java.io.IOException;

public final class DataMaskingPolicyProperties
implements JsonSerializable<DataMaskingPolicyProperties> {
    private DataMaskingState dataMaskingState;
    private String exemptPrincipals;
    private String applicationPrincipals;
    private String maskingLevel;
    private static final ClientLogger LOGGER = new ClientLogger(DataMaskingPolicyProperties.class);

    public DataMaskingState dataMaskingState() {
        return this.dataMaskingState;
    }

    public DataMaskingPolicyProperties withDataMaskingState(DataMaskingState dataMaskingState) {
        this.dataMaskingState = dataMaskingState;
        return this;
    }

    public String exemptPrincipals() {
        return this.exemptPrincipals;
    }

    public DataMaskingPolicyProperties withExemptPrincipals(String exemptPrincipals) {
        this.exemptPrincipals = exemptPrincipals;
        return this;
    }

    public String applicationPrincipals() {
        return this.applicationPrincipals;
    }

    public String maskingLevel() {
        return this.maskingLevel;
    }

    public void validate() {
        if (this.dataMaskingState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataMaskingState in model DataMaskingPolicyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataMaskingState", this.dataMaskingState == null ? null : this.dataMaskingState.toString());
        jsonWriter.writeStringField("exemptPrincipals", this.exemptPrincipals);
        return jsonWriter.writeEndObject();
    }

    public static DataMaskingPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataMaskingPolicyProperties)jsonReader.readObject(reader -> {
            DataMaskingPolicyProperties deserializedDataMaskingPolicyProperties = new DataMaskingPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataMaskingState".equals(fieldName)) {
                    deserializedDataMaskingPolicyProperties.dataMaskingState = DataMaskingState.fromString(reader.getString());
                    continue;
                }
                if ("exemptPrincipals".equals(fieldName)) {
                    deserializedDataMaskingPolicyProperties.exemptPrincipals = reader.getString();
                    continue;
                }
                if ("applicationPrincipals".equals(fieldName)) {
                    deserializedDataMaskingPolicyProperties.applicationPrincipals = reader.getString();
                    continue;
                }
                if ("maskingLevel".equals(fieldName)) {
                    deserializedDataMaskingPolicyProperties.maskingLevel = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataMaskingPolicyProperties;
        });
    }
}

