/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.servicebus.models.Encryption;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SBNamespaceProperties
implements JsonSerializable<SBNamespaceProperties> {
    private String provisioningState;
    private String status;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private String serviceBusEndpoint;
    private String metricId;
    private Boolean zoneRedundant;
    private Encryption encryption;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private Boolean disableLocalAuth;
    private String alternateName;

    public String provisioningState() {
        return this.provisioningState;
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public String serviceBusEndpoint() {
        return this.serviceBusEndpoint;
    }

    public String metricId() {
        return this.metricId;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public SBNamespaceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public SBNamespaceProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public SBNamespaceProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public SBNamespaceProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public String alternateName() {
        return this.alternateName;
    }

    public SBNamespaceProperties withAlternateName(String alternateName) {
        this.alternateName = alternateName;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeStringField("alternateName", this.alternateName);
        return jsonWriter.writeEndObject();
    }

    public static SBNamespaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SBNamespaceProperties)jsonReader.readObject(reader -> {
            SBNamespaceProperties deserializedSBNamespaceProperties = new SBNamespaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedSBNamespaceProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSBNamespaceProperties.status = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedSBNamespaceProperties.createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedSBNamespaceProperties.updatedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("serviceBusEndpoint".equals(fieldName)) {
                    deserializedSBNamespaceProperties.serviceBusEndpoint = reader.getString();
                    continue;
                }
                if ("metricId".equals(fieldName)) {
                    deserializedSBNamespaceProperties.metricId = reader.getString();
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedSBNamespaceProperties.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedSBNamespaceProperties.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedSBNamespaceProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedSBNamespaceProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("alternateName".equals(fieldName)) {
                    deserializedSBNamespaceProperties.alternateName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBNamespaceProperties;
        });
    }
}

