/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.models.AccessRule;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityProfile
implements JsonSerializable<NetworkSecurityProfile> {
    private String name;
    private Integer accessRulesVersion;
    private List<AccessRule> accessRules;
    private Integer diagnosticSettingsVersion;
    private List<String> enabledLogCategories;

    public String name() {
        return this.name;
    }

    public NetworkSecurityProfile withName(String name) {
        this.name = name;
        return this;
    }

    public Integer accessRulesVersion() {
        return this.accessRulesVersion;
    }

    public NetworkSecurityProfile withAccessRulesVersion(Integer accessRulesVersion) {
        this.accessRulesVersion = accessRulesVersion;
        return this;
    }

    public List<AccessRule> accessRules() {
        return this.accessRules;
    }

    public NetworkSecurityProfile withAccessRules(List<AccessRule> accessRules) {
        this.accessRules = accessRules;
        return this;
    }

    public Integer diagnosticSettingsVersion() {
        return this.diagnosticSettingsVersion;
    }

    public NetworkSecurityProfile withDiagnosticSettingsVersion(Integer diagnosticSettingsVersion) {
        this.diagnosticSettingsVersion = diagnosticSettingsVersion;
        return this;
    }

    public List<String> enabledLogCategories() {
        return this.enabledLogCategories;
    }

    public NetworkSecurityProfile withEnabledLogCategories(List<String> enabledLogCategories) {
        this.enabledLogCategories = enabledLogCategories;
        return this;
    }

    public void validate() {
        if (this.accessRules() != null) {
            this.accessRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("accessRulesVersion", (Number)this.accessRulesVersion);
        jsonWriter.writeArrayField("accessRules", this.accessRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("diagnosticSettingsVersion", (Number)this.diagnosticSettingsVersion);
        jsonWriter.writeArrayField("enabledLogCategories", this.enabledLogCategories, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityProfile)jsonReader.readObject(reader -> {
            NetworkSecurityProfile deserializedNetworkSecurityProfile = new NetworkSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityProfile.name = reader.getString();
                    continue;
                }
                if ("accessRulesVersion".equals(fieldName)) {
                    deserializedNetworkSecurityProfile.accessRulesVersion = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("accessRules".equals(fieldName)) {
                    List accessRules;
                    deserializedNetworkSecurityProfile.accessRules = accessRules = reader.readArray(reader1 -> AccessRule.fromJson(reader1));
                    continue;
                }
                if ("diagnosticSettingsVersion".equals(fieldName)) {
                    deserializedNetworkSecurityProfile.diagnosticSettingsVersion = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enabledLogCategories".equals(fieldName)) {
                    List enabledLogCategories;
                    deserializedNetworkSecurityProfile.enabledLogCategories = enabledLogCategories = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityProfile;
        });
    }
}

