/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ExportTemplateOutputFormat;
import java.io.IOException;
import java.util.List;

public final class ExportTemplateRequest
implements JsonSerializable<ExportTemplateRequest> {
    private List<String> resources;
    private String options;
    private ExportTemplateOutputFormat outputFormat;

    public List<String> resources() {
        return this.resources;
    }

    public ExportTemplateRequest withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public String options() {
        return this.options;
    }

    public ExportTemplateRequest withOptions(String options) {
        this.options = options;
        return this;
    }

    public ExportTemplateOutputFormat outputFormat() {
        return this.outputFormat;
    }

    public ExportTemplateRequest withOutputFormat(ExportTemplateOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("options", this.options);
        jsonWriter.writeStringField("outputFormat", this.outputFormat == null ? null : this.outputFormat.toString());
        return jsonWriter.writeEndObject();
    }

    public static ExportTemplateRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ExportTemplateRequest)jsonReader.readObject(reader -> {
            ExportTemplateRequest deserializedExportTemplateRequest = new ExportTemplateRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedExportTemplateRequest.resources = resources = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedExportTemplateRequest.options = reader.getString();
                    continue;
                }
                if ("outputFormat".equals(fieldName)) {
                    deserializedExportTemplateRequest.outputFormat = ExportTemplateOutputFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportTemplateRequest;
        });
    }
}

