/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.DataBoundariesClient;
import com.azure.resourcemanager.resources.fluent.models.DataBoundaryDefinitionInner;
import com.azure.resourcemanager.resources.implementation.DataBoundariesManagementClientImpl;
import com.azure.resourcemanager.resources.models.DefaultName;
import reactor.core.publisher.Mono;

public final class DataBoundariesClientImpl
implements DataBoundariesClient {
    private final DataBoundariesService service;
    private final DataBoundariesManagementClientImpl client;

    DataBoundariesClientImpl(DataBoundariesManagementClientImpl client) {
        this.service = (DataBoundariesService)RestProxy.create(DataBoundariesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataBoundaryDefinitionInner>> putWithResponseAsync(DefaultName defaultParameter, DataBoundaryDefinitionInner dataBoundaryDefinition) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (dataBoundaryDefinition == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataBoundaryDefinition is required and cannot be null."));
        }
        dataBoundaryDefinition.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), this.client.getApiVersion(), defaultParameter, dataBoundaryDefinition, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataBoundaryDefinitionInner>> putWithResponseAsync(DefaultName defaultParameter, DataBoundaryDefinitionInner dataBoundaryDefinition, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (dataBoundaryDefinition == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataBoundaryDefinition is required and cannot be null."));
        }
        dataBoundaryDefinition.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.put(this.client.getEndpoint(), this.client.getApiVersion(), defaultParameter, dataBoundaryDefinition, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataBoundaryDefinitionInner> putAsync(DefaultName defaultParameter, DataBoundaryDefinitionInner dataBoundaryDefinition) {
        return this.putWithResponseAsync(defaultParameter, dataBoundaryDefinition).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DataBoundaryDefinitionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataBoundaryDefinitionInner> putWithResponse(DefaultName defaultParameter, DataBoundaryDefinitionInner dataBoundaryDefinition, Context context) {
        return (Response)this.putWithResponseAsync(defaultParameter, dataBoundaryDefinition, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataBoundaryDefinitionInner put(DefaultName defaultParameter, DataBoundaryDefinitionInner dataBoundaryDefinition) {
        return (DataBoundaryDefinitionInner)((Object)this.putWithResponse(defaultParameter, dataBoundaryDefinition, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataBoundaryDefinitionInner>> getTenantWithResponseAsync(DefaultName defaultParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTenant(this.client.getEndpoint(), this.client.getApiVersion(), defaultParameter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataBoundaryDefinitionInner>> getTenantWithResponseAsync(DefaultName defaultParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getTenant(this.client.getEndpoint(), this.client.getApiVersion(), defaultParameter, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataBoundaryDefinitionInner> getTenantAsync(DefaultName defaultParameter) {
        return this.getTenantWithResponseAsync(defaultParameter).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DataBoundaryDefinitionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataBoundaryDefinitionInner> getTenantWithResponse(DefaultName defaultParameter, Context context) {
        return (Response)this.getTenantWithResponseAsync(defaultParameter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataBoundaryDefinitionInner getTenant(DefaultName defaultParameter) {
        return (DataBoundaryDefinitionInner)((Object)this.getTenantWithResponse(defaultParameter, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataBoundaryDefinitionInner>> getScopeWithResponseAsync(String scope, DefaultName defaultParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), defaultParameter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataBoundaryDefinitionInner>> getScopeWithResponseAsync(String scope, DefaultName defaultParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), defaultParameter, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataBoundaryDefinitionInner> getScopeAsync(String scope, DefaultName defaultParameter) {
        return this.getScopeWithResponseAsync(scope, defaultParameter).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DataBoundaryDefinitionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataBoundaryDefinitionInner> getScopeWithResponse(String scope, DefaultName defaultParameter, Context context) {
        return (Response)this.getScopeWithResponseAsync(scope, defaultParameter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataBoundaryDefinitionInner getScope(String scope, DefaultName defaultParameter) {
        return (DataBoundaryDefinitionInner)((Object)this.getScopeWithResponse(scope, defaultParameter, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataBoundariesManage")
    public static interface DataBoundariesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Resources/dataBoundaries/{default}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataBoundaryDefinitionInner>> put(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="default") DefaultName var3, @BodyParam(value="application/json") DataBoundaryDefinitionInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Resources/dataBoundaries/{default}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataBoundaryDefinitionInner>> getTenant(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="default") DefaultName var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataBoundaryDefinitionInner>> getScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="default") DefaultName var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

