/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.ChangeResourceResultInner;
import java.io.IOException;
import java.util.List;

public final class ChangeResourceListResult
implements JsonSerializable<ChangeResourceListResult> {
    private String nextLink;
    private List<ChangeResourceResultInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ChangeResourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ChangeResourceResultInner> value() {
        return this.value;
    }

    public ChangeResourceListResult withValue(List<ChangeResourceResultInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChangeResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ChangeResourceListResult)jsonReader.readObject(reader -> {
            ChangeResourceListResult deserializedChangeResourceListResult = new ChangeResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedChangeResourceListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedChangeResourceListResult.value = value = reader.readArray(reader1 -> ChangeResourceResultInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChangeResourceListResult;
        });
    }
}

