/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.TagCount;
import java.io.IOException;

public final class TagValueInner
implements JsonSerializable<TagValueInner> {
    private String id;
    private String tagValue;
    private TagCount count;

    public String id() {
        return this.id;
    }

    public String tagValue() {
        return this.tagValue;
    }

    public TagValueInner withTagValue(String tagValue) {
        this.tagValue = tagValue;
        return this;
    }

    public TagCount count() {
        return this.count;
    }

    public TagValueInner withCount(TagCount count) {
        this.count = count;
        return this;
    }

    public void validate() {
        if (this.count() != null) {
            this.count().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tagValue", this.tagValue);
        jsonWriter.writeJsonField("count", (JsonSerializable)this.count);
        return jsonWriter.writeEndObject();
    }

    public static TagValueInner fromJson(JsonReader jsonReader) throws IOException {
        return (TagValueInner)jsonReader.readObject(reader -> {
            TagValueInner deserializedTagValueInner = new TagValueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTagValueInner.id = reader.getString();
                    continue;
                }
                if ("tagValue".equals(fieldName)) {
                    deserializedTagValueInner.tagValue = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedTagValueInner.count = TagCount.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagValueInner;
        });
    }
}

