/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.TagValueInner;
import com.azure.resourcemanager.resources.models.TagCount;
import java.io.IOException;
import java.util.List;

public final class TagDetailsInner
implements JsonSerializable<TagDetailsInner> {
    private String id;
    private String tagName;
    private TagCount count;
    private List<TagValueInner> values;

    public String id() {
        return this.id;
    }

    public String tagName() {
        return this.tagName;
    }

    public TagDetailsInner withTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public TagCount count() {
        return this.count;
    }

    public TagDetailsInner withCount(TagCount count) {
        this.count = count;
        return this;
    }

    public List<TagValueInner> values() {
        return this.values;
    }

    public TagDetailsInner withValues(List<TagValueInner> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.count() != null) {
            this.count().validate();
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tagName", this.tagName);
        jsonWriter.writeJsonField("count", (JsonSerializable)this.count);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TagDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return (TagDetailsInner)jsonReader.readObject(reader -> {
            TagDetailsInner deserializedTagDetailsInner = new TagDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTagDetailsInner.id = reader.getString();
                    continue;
                }
                if ("tagName".equals(fieldName)) {
                    deserializedTagDetailsInner.tagName = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedTagDetailsInner.count = TagCount.fromJson(reader);
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedTagDetailsInner.values = values = reader.readArray(reader1 -> TagValueInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagDetailsInner;
        });
    }
}

