/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AssignmentScopeValidation;
import com.azure.resourcemanager.resources.models.ExemptionCategory;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class PolicyExemptionProperties
implements JsonSerializable<PolicyExemptionProperties> {
    private String policyAssignmentId;
    private List<String> policyDefinitionReferenceIds;
    private ExemptionCategory exemptionCategory;
    private OffsetDateTime expiresOn;
    private String displayName;
    private String description;
    private Object metadata;
    private List<ResourceSelector> resourceSelectors;
    private AssignmentScopeValidation assignmentScopeValidation;
    private static final ClientLogger LOGGER = new ClientLogger(PolicyExemptionProperties.class);

    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    public PolicyExemptionProperties withPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    public List<String> policyDefinitionReferenceIds() {
        return this.policyDefinitionReferenceIds;
    }

    public PolicyExemptionProperties withPolicyDefinitionReferenceIds(List<String> policyDefinitionReferenceIds) {
        this.policyDefinitionReferenceIds = policyDefinitionReferenceIds;
        return this;
    }

    public ExemptionCategory exemptionCategory() {
        return this.exemptionCategory;
    }

    public PolicyExemptionProperties withExemptionCategory(ExemptionCategory exemptionCategory) {
        this.exemptionCategory = exemptionCategory;
        return this;
    }

    public OffsetDateTime expiresOn() {
        return this.expiresOn;
    }

    public PolicyExemptionProperties withExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public PolicyExemptionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicyExemptionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicyExemptionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    public PolicyExemptionProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    public AssignmentScopeValidation assignmentScopeValidation() {
        return this.assignmentScopeValidation;
    }

    public PolicyExemptionProperties withAssignmentScopeValidation(AssignmentScopeValidation assignmentScopeValidation) {
        this.assignmentScopeValidation = assignmentScopeValidation;
        return this;
    }

    public void validate() {
        if (this.policyAssignmentId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyAssignmentId in model PolicyExemptionProperties"));
        }
        if (this.exemptionCategory() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property exemptionCategory in model PolicyExemptionProperties"));
        }
        if (this.resourceSelectors() != null) {
            this.resourceSelectors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("exemptionCategory", this.exemptionCategory == null ? null : this.exemptionCategory.toString());
        jsonWriter.writeArrayField("policyDefinitionReferenceIds", this.policyDefinitionReferenceIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("expiresOn", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        if (this.metadata != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata);
        }
        jsonWriter.writeArrayField("resourceSelectors", this.resourceSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("assignmentScopeValidation", this.assignmentScopeValidation == null ? null : this.assignmentScopeValidation.toString());
        return jsonWriter.writeEndObject();
    }

    public static PolicyExemptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyExemptionProperties)jsonReader.readObject(reader -> {
            PolicyExemptionProperties deserializedPolicyExemptionProperties = new PolicyExemptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("exemptionCategory".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.exemptionCategory = ExemptionCategory.fromString(reader.getString());
                    continue;
                }
                if ("policyDefinitionReferenceIds".equals(fieldName)) {
                    List policyDefinitionReferenceIds;
                    deserializedPolicyExemptionProperties.policyDefinitionReferenceIds = policyDefinitionReferenceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("expiresOn".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.description = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.metadata = reader.readUntyped();
                    continue;
                }
                if ("resourceSelectors".equals(fieldName)) {
                    List resourceSelectors;
                    deserializedPolicyExemptionProperties.resourceSelectors = resourceSelectors = reader.readArray(reader1 -> ResourceSelector.fromJson(reader1));
                    continue;
                }
                if ("assignmentScopeValidation".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.assignmentScopeValidation = AssignmentScopeValidation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyExemptionProperties;
        });
    }
}

