/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AvailabilityZoneMappings;
import com.azure.resourcemanager.resources.models.LocationMetadata;
import com.azure.resourcemanager.resources.models.LocationType;
import java.io.IOException;
import java.util.List;

public final class LocationInner
implements JsonSerializable<LocationInner> {
    private String id;
    private String subscriptionId;
    private String name;
    private LocationType type;
    private String displayName;
    private String regionalDisplayName;
    private LocationMetadata metadata;
    private List<AvailabilityZoneMappings> availabilityZoneMappings;

    public String id() {
        return this.id;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String name() {
        return this.name;
    }

    public LocationType type() {
        return this.type;
    }

    public String displayName() {
        return this.displayName;
    }

    public String regionalDisplayName() {
        return this.regionalDisplayName;
    }

    public LocationMetadata metadata() {
        return this.metadata;
    }

    public LocationInner withMetadata(LocationMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<AvailabilityZoneMappings> availabilityZoneMappings() {
        return this.availabilityZoneMappings;
    }

    public LocationInner withAvailabilityZoneMappings(List<AvailabilityZoneMappings> availabilityZoneMappings) {
        this.availabilityZoneMappings = availabilityZoneMappings;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().validate();
        }
        if (this.availabilityZoneMappings() != null) {
            this.availabilityZoneMappings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", (JsonSerializable)this.metadata);
        jsonWriter.writeArrayField("availabilityZoneMappings", this.availabilityZoneMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static LocationInner fromJson(JsonReader jsonReader) throws IOException {
        return (LocationInner)jsonReader.readObject(reader -> {
            LocationInner deserializedLocationInner = new LocationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLocationInner.id = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedLocationInner.subscriptionId = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLocationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLocationInner.type = LocationType.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedLocationInner.displayName = reader.getString();
                    continue;
                }
                if ("regionalDisplayName".equals(fieldName)) {
                    deserializedLocationInner.regionalDisplayName = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedLocationInner.metadata = LocationMetadata.fromJson(reader);
                    continue;
                }
                if ("availabilityZoneMappings".equals(fieldName)) {
                    List availabilityZoneMappings;
                    deserializedLocationInner.availabilityZoneMappings = availabilityZoneMappings = reader.readArray(reader1 -> AvailabilityZoneMappings.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocationInner;
        });
    }
}

