/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ActionOnUnmanage;
import com.azure.resourcemanager.resources.models.DenySettings;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentStackProvisioningState;
import com.azure.resourcemanager.resources.models.DeploymentStacksDebugSetting;
import com.azure.resourcemanager.resources.models.DeploymentStacksParametersLink;
import com.azure.resourcemanager.resources.models.DeploymentStacksTemplateLink;
import com.azure.resourcemanager.resources.models.ManagedResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReferenceExtended;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DeploymentStackProperties
implements JsonSerializable<DeploymentStackProperties> {
    private Object template;
    private DeploymentStacksTemplateLink templateLink;
    private Map<String, DeploymentParameter> parameters;
    private DeploymentStacksParametersLink parametersLink;
    private ActionOnUnmanage actionOnUnmanage;
    private DeploymentStacksDebugSetting debugSetting;
    private Boolean bypassStackOutOfSyncError;
    private String deploymentScope;
    private String description;
    private DenySettings denySettings;
    private DeploymentStackProvisioningState provisioningState;
    private String correlationId;
    private List<ResourceReference> detachedResources;
    private List<ResourceReference> deletedResources;
    private List<ResourceReferenceExtended> failedResources;
    private List<ManagedResourceReference> resources;
    private String deploymentId;
    private Object outputs;
    private String duration;
    private ManagementError error;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentStackProperties.class);

    public Object template() {
        return this.template;
    }

    public DeploymentStackProperties withTemplate(Object template) {
        this.template = template;
        return this;
    }

    public DeploymentStacksTemplateLink templateLink() {
        return this.templateLink;
    }

    public DeploymentStackProperties withTemplateLink(DeploymentStacksTemplateLink templateLink) {
        this.templateLink = templateLink;
        return this;
    }

    public Map<String, DeploymentParameter> parameters() {
        return this.parameters;
    }

    public DeploymentStackProperties withParameters(Map<String, DeploymentParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public DeploymentStacksParametersLink parametersLink() {
        return this.parametersLink;
    }

    public DeploymentStackProperties withParametersLink(DeploymentStacksParametersLink parametersLink) {
        this.parametersLink = parametersLink;
        return this;
    }

    public ActionOnUnmanage actionOnUnmanage() {
        return this.actionOnUnmanage;
    }

    public DeploymentStackProperties withActionOnUnmanage(ActionOnUnmanage actionOnUnmanage) {
        this.actionOnUnmanage = actionOnUnmanage;
        return this;
    }

    public DeploymentStacksDebugSetting debugSetting() {
        return this.debugSetting;
    }

    public DeploymentStackProperties withDebugSetting(DeploymentStacksDebugSetting debugSetting) {
        this.debugSetting = debugSetting;
        return this;
    }

    public Boolean bypassStackOutOfSyncError() {
        return this.bypassStackOutOfSyncError;
    }

    public DeploymentStackProperties withBypassStackOutOfSyncError(Boolean bypassStackOutOfSyncError) {
        this.bypassStackOutOfSyncError = bypassStackOutOfSyncError;
        return this;
    }

    public String deploymentScope() {
        return this.deploymentScope;
    }

    public DeploymentStackProperties withDeploymentScope(String deploymentScope) {
        this.deploymentScope = deploymentScope;
        return this;
    }

    public String description() {
        return this.description;
    }

    public DeploymentStackProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public DenySettings denySettings() {
        return this.denySettings;
    }

    public DeploymentStackProperties withDenySettings(DenySettings denySettings) {
        this.denySettings = denySettings;
        return this;
    }

    public DeploymentStackProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public List<ResourceReference> detachedResources() {
        return this.detachedResources;
    }

    public List<ResourceReference> deletedResources() {
        return this.deletedResources;
    }

    public List<ResourceReferenceExtended> failedResources() {
        return this.failedResources;
    }

    public List<ManagedResourceReference> resources() {
        return this.resources;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public Object outputs() {
        return this.outputs;
    }

    public String duration() {
        return this.duration;
    }

    public ManagementError error() {
        return this.error;
    }

    public DeploymentStackProperties withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.templateLink() != null) {
            this.templateLink().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.parametersLink() != null) {
            this.parametersLink().validate();
        }
        if (this.actionOnUnmanage() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actionOnUnmanage in model DeploymentStackProperties"));
        }
        this.actionOnUnmanage().validate();
        if (this.debugSetting() != null) {
            this.debugSetting().validate();
        }
        if (this.denySettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property denySettings in model DeploymentStackProperties"));
        }
        this.denySettings().validate();
        if (this.detachedResources() != null) {
            this.detachedResources().forEach(e -> e.validate());
        }
        if (this.deletedResources() != null) {
            this.deletedResources().forEach(e -> e.validate());
        }
        if (this.failedResources() != null) {
            this.failedResources().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("actionOnUnmanage", (JsonSerializable)this.actionOnUnmanage);
        jsonWriter.writeJsonField("denySettings", (JsonSerializable)this.denySettings);
        if (this.template != null) {
            jsonWriter.writeUntypedField("template", this.template);
        }
        jsonWriter.writeJsonField("templateLink", (JsonSerializable)this.templateLink);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("parametersLink", (JsonSerializable)this.parametersLink);
        jsonWriter.writeJsonField("debugSetting", (JsonSerializable)this.debugSetting);
        jsonWriter.writeBooleanField("bypassStackOutOfSyncError", this.bypassStackOutOfSyncError);
        jsonWriter.writeStringField("deploymentScope", this.deploymentScope);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentStackProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentStackProperties)jsonReader.readObject(reader -> {
            DeploymentStackProperties deserializedDeploymentStackProperties = new DeploymentStackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionOnUnmanage".equals(fieldName)) {
                    deserializedDeploymentStackProperties.actionOnUnmanage = ActionOnUnmanage.fromJson(reader);
                    continue;
                }
                if ("denySettings".equals(fieldName)) {
                    deserializedDeploymentStackProperties.denySettings = DenySettings.fromJson(reader);
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedDeploymentStackProperties.template = reader.readUntyped();
                    continue;
                }
                if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentStackProperties.templateLink = DeploymentStacksTemplateLink.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDeploymentStackProperties.parameters = parameters = reader.readMap(reader1 -> DeploymentParameter.fromJson(reader1));
                    continue;
                }
                if ("parametersLink".equals(fieldName)) {
                    deserializedDeploymentStackProperties.parametersLink = DeploymentStacksParametersLink.fromJson(reader);
                    continue;
                }
                if ("debugSetting".equals(fieldName)) {
                    deserializedDeploymentStackProperties.debugSetting = DeploymentStacksDebugSetting.fromJson(reader);
                    continue;
                }
                if ("bypassStackOutOfSyncError".equals(fieldName)) {
                    deserializedDeploymentStackProperties.bypassStackOutOfSyncError = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deploymentScope".equals(fieldName)) {
                    deserializedDeploymentStackProperties.deploymentScope = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDeploymentStackProperties.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDeploymentStackProperties.provisioningState = DeploymentStackProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedDeploymentStackProperties.correlationId = reader.getString();
                    continue;
                }
                if ("detachedResources".equals(fieldName)) {
                    List detachedResources;
                    deserializedDeploymentStackProperties.detachedResources = detachedResources = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    continue;
                }
                if ("deletedResources".equals(fieldName)) {
                    List deletedResources;
                    deserializedDeploymentStackProperties.deletedResources = deletedResources = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    continue;
                }
                if ("failedResources".equals(fieldName)) {
                    List failedResources;
                    deserializedDeploymentStackProperties.failedResources = failedResources = reader.readArray(reader1 -> ResourceReferenceExtended.fromJson(reader1));
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedDeploymentStackProperties.resources = resources = reader.readArray(reader1 -> ManagedResourceReference.fromJson(reader1));
                    continue;
                }
                if ("deploymentId".equals(fieldName)) {
                    deserializedDeploymentStackProperties.deploymentId = reader.getString();
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    deserializedDeploymentStackProperties.outputs = reader.readUntyped();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedDeploymentStackProperties.duration = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDeploymentStackProperties.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentStackProperties;
        });
    }
}

