/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.DayOfWeek;
import java.io.IOException;
import java.time.Duration;

public final class ScheduleEntry
implements JsonSerializable<ScheduleEntry> {
    private DayOfWeek dayOfWeek;
    private int startHourUtc;
    private Duration maintenanceWindow;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleEntry.class);

    public DayOfWeek dayOfWeek() {
        return this.dayOfWeek;
    }

    public ScheduleEntry withDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    public int startHourUtc() {
        return this.startHourUtc;
    }

    public ScheduleEntry withStartHourUtc(int startHourUtc) {
        this.startHourUtc = startHourUtc;
        return this;
    }

    public Duration maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ScheduleEntry withMaintenanceWindow(Duration maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public void validate() {
        if (this.dayOfWeek() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dayOfWeek in model ScheduleEntry"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dayOfWeek", this.dayOfWeek == null ? null : this.dayOfWeek.toString());
        jsonWriter.writeIntField("startHourUtc", this.startHourUtc);
        jsonWriter.writeStringField("maintenanceWindow", CoreUtils.durationToStringWithDays((Duration)this.maintenanceWindow));
        return jsonWriter.writeEndObject();
    }

    public static ScheduleEntry fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleEntry)jsonReader.readObject(reader -> {
            ScheduleEntry deserializedScheduleEntry = new ScheduleEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dayOfWeek".equals(fieldName)) {
                    deserializedScheduleEntry.dayOfWeek = DayOfWeek.fromString(reader.getString());
                    continue;
                }
                if ("startHourUtc".equals(fieldName)) {
                    deserializedScheduleEntry.startHourUtc = reader.getInt();
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedScheduleEntry.maintenanceWindow = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleEntry;
        });
    }
}

