/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RedisConfiguration
implements JsonSerializable<RedisConfiguration> {
    private String rdbBackupEnabled;
    private String rdbBackupFrequency;
    private String rdbBackupMaxSnapshotCount;
    private String rdbStorageConnectionString;
    private String aofBackupEnabled;
    private String aofStorageConnectionString0;
    private String aofStorageConnectionString1;
    private String maxfragmentationmemoryReserved;
    private String maxmemoryPolicy;
    private String maxmemoryReserved;
    private String maxmemoryDelta;
    private String maxclients;
    private String notifyKeyspaceEvents;
    private String preferredDataArchiveAuthMethod;
    private String preferredDataPersistenceAuthMethod;
    private String zonalConfiguration;
    private String authnotrequired;
    private String storageSubscriptionId;
    private String aadEnabled;
    private Map<String, String> additionalProperties;

    public String rdbBackupEnabled() {
        return this.rdbBackupEnabled;
    }

    public RedisConfiguration withRdbBackupEnabled(String rdbBackupEnabled) {
        this.rdbBackupEnabled = rdbBackupEnabled;
        return this;
    }

    public String rdbBackupFrequency() {
        return this.rdbBackupFrequency;
    }

    public RedisConfiguration withRdbBackupFrequency(String rdbBackupFrequency) {
        this.rdbBackupFrequency = rdbBackupFrequency;
        return this;
    }

    public String rdbBackupMaxSnapshotCount() {
        return this.rdbBackupMaxSnapshotCount;
    }

    public RedisConfiguration withRdbBackupMaxSnapshotCount(String rdbBackupMaxSnapshotCount) {
        this.rdbBackupMaxSnapshotCount = rdbBackupMaxSnapshotCount;
        return this;
    }

    public String rdbStorageConnectionString() {
        return this.rdbStorageConnectionString;
    }

    public RedisConfiguration withRdbStorageConnectionString(String rdbStorageConnectionString) {
        this.rdbStorageConnectionString = rdbStorageConnectionString;
        return this;
    }

    public String aofBackupEnabled() {
        return this.aofBackupEnabled;
    }

    public RedisConfiguration withAofBackupEnabled(String aofBackupEnabled) {
        this.aofBackupEnabled = aofBackupEnabled;
        return this;
    }

    public String aofStorageConnectionString0() {
        return this.aofStorageConnectionString0;
    }

    public RedisConfiguration withAofStorageConnectionString0(String aofStorageConnectionString0) {
        this.aofStorageConnectionString0 = aofStorageConnectionString0;
        return this;
    }

    public String aofStorageConnectionString1() {
        return this.aofStorageConnectionString1;
    }

    public RedisConfiguration withAofStorageConnectionString1(String aofStorageConnectionString1) {
        this.aofStorageConnectionString1 = aofStorageConnectionString1;
        return this;
    }

    public String maxfragmentationmemoryReserved() {
        return this.maxfragmentationmemoryReserved;
    }

    public RedisConfiguration withMaxfragmentationmemoryReserved(String maxfragmentationmemoryReserved) {
        this.maxfragmentationmemoryReserved = maxfragmentationmemoryReserved;
        return this;
    }

    public String maxmemoryPolicy() {
        return this.maxmemoryPolicy;
    }

    public RedisConfiguration withMaxmemoryPolicy(String maxmemoryPolicy) {
        this.maxmemoryPolicy = maxmemoryPolicy;
        return this;
    }

    public String maxmemoryReserved() {
        return this.maxmemoryReserved;
    }

    public RedisConfiguration withMaxmemoryReserved(String maxmemoryReserved) {
        this.maxmemoryReserved = maxmemoryReserved;
        return this;
    }

    public String maxmemoryDelta() {
        return this.maxmemoryDelta;
    }

    public RedisConfiguration withMaxmemoryDelta(String maxmemoryDelta) {
        this.maxmemoryDelta = maxmemoryDelta;
        return this;
    }

    public String maxclients() {
        return this.maxclients;
    }

    public String notifyKeyspaceEvents() {
        return this.notifyKeyspaceEvents;
    }

    public RedisConfiguration withNotifyKeyspaceEvents(String notifyKeyspaceEvents) {
        this.notifyKeyspaceEvents = notifyKeyspaceEvents;
        return this;
    }

    public String preferredDataArchiveAuthMethod() {
        return this.preferredDataArchiveAuthMethod;
    }

    public String preferredDataPersistenceAuthMethod() {
        return this.preferredDataPersistenceAuthMethod;
    }

    public RedisConfiguration withPreferredDataPersistenceAuthMethod(String preferredDataPersistenceAuthMethod) {
        this.preferredDataPersistenceAuthMethod = preferredDataPersistenceAuthMethod;
        return this;
    }

    public String zonalConfiguration() {
        return this.zonalConfiguration;
    }

    public String authnotrequired() {
        return this.authnotrequired;
    }

    public RedisConfiguration withAuthnotrequired(String authnotrequired) {
        this.authnotrequired = authnotrequired;
        return this;
    }

    public String storageSubscriptionId() {
        return this.storageSubscriptionId;
    }

    public RedisConfiguration withStorageSubscriptionId(String storageSubscriptionId) {
        this.storageSubscriptionId = storageSubscriptionId;
        return this;
    }

    public String aadEnabled() {
        return this.aadEnabled;
    }

    public RedisConfiguration withAadEnabled(String aadEnabled) {
        this.aadEnabled = aadEnabled;
        return this;
    }

    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    public RedisConfiguration withAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("rdb-backup-enabled", this.rdbBackupEnabled);
        jsonWriter.writeStringField("rdb-backup-frequency", this.rdbBackupFrequency);
        jsonWriter.writeStringField("rdb-backup-max-snapshot-count", this.rdbBackupMaxSnapshotCount);
        jsonWriter.writeStringField("rdb-storage-connection-string", this.rdbStorageConnectionString);
        jsonWriter.writeStringField("aof-backup-enabled", this.aofBackupEnabled);
        jsonWriter.writeStringField("aof-storage-connection-string-0", this.aofStorageConnectionString0);
        jsonWriter.writeStringField("aof-storage-connection-string-1", this.aofStorageConnectionString1);
        jsonWriter.writeStringField("maxfragmentationmemory-reserved", this.maxfragmentationmemoryReserved);
        jsonWriter.writeStringField("maxmemory-policy", this.maxmemoryPolicy);
        jsonWriter.writeStringField("maxmemory-reserved", this.maxmemoryReserved);
        jsonWriter.writeStringField("maxmemory-delta", this.maxmemoryDelta);
        jsonWriter.writeStringField("notify-keyspace-events", this.notifyKeyspaceEvents);
        jsonWriter.writeStringField("preferred-data-persistence-auth-method", this.preferredDataPersistenceAuthMethod);
        jsonWriter.writeStringField("authnotrequired", this.authnotrequired);
        jsonWriter.writeStringField("storage-subscription-id", this.storageSubscriptionId);
        jsonWriter.writeStringField("aad-enabled", this.aadEnabled);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, String> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), (Object)additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RedisConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (RedisConfiguration)jsonReader.readObject(reader -> {
            RedisConfiguration deserializedRedisConfiguration = new RedisConfiguration();
            LinkedHashMap<String, String> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rdb-backup-enabled".equals(fieldName)) {
                    deserializedRedisConfiguration.rdbBackupEnabled = reader.getString();
                    continue;
                }
                if ("rdb-backup-frequency".equals(fieldName)) {
                    deserializedRedisConfiguration.rdbBackupFrequency = reader.getString();
                    continue;
                }
                if ("rdb-backup-max-snapshot-count".equals(fieldName)) {
                    deserializedRedisConfiguration.rdbBackupMaxSnapshotCount = reader.getString();
                    continue;
                }
                if ("rdb-storage-connection-string".equals(fieldName)) {
                    deserializedRedisConfiguration.rdbStorageConnectionString = reader.getString();
                    continue;
                }
                if ("aof-backup-enabled".equals(fieldName)) {
                    deserializedRedisConfiguration.aofBackupEnabled = reader.getString();
                    continue;
                }
                if ("aof-storage-connection-string-0".equals(fieldName)) {
                    deserializedRedisConfiguration.aofStorageConnectionString0 = reader.getString();
                    continue;
                }
                if ("aof-storage-connection-string-1".equals(fieldName)) {
                    deserializedRedisConfiguration.aofStorageConnectionString1 = reader.getString();
                    continue;
                }
                if ("maxfragmentationmemory-reserved".equals(fieldName)) {
                    deserializedRedisConfiguration.maxfragmentationmemoryReserved = reader.getString();
                    continue;
                }
                if ("maxmemory-policy".equals(fieldName)) {
                    deserializedRedisConfiguration.maxmemoryPolicy = reader.getString();
                    continue;
                }
                if ("maxmemory-reserved".equals(fieldName)) {
                    deserializedRedisConfiguration.maxmemoryReserved = reader.getString();
                    continue;
                }
                if ("maxmemory-delta".equals(fieldName)) {
                    deserializedRedisConfiguration.maxmemoryDelta = reader.getString();
                    continue;
                }
                if ("maxclients".equals(fieldName)) {
                    deserializedRedisConfiguration.maxclients = reader.getString();
                    continue;
                }
                if ("notify-keyspace-events".equals(fieldName)) {
                    deserializedRedisConfiguration.notifyKeyspaceEvents = reader.getString();
                    continue;
                }
                if ("preferred-data-archive-auth-method".equals(fieldName)) {
                    deserializedRedisConfiguration.preferredDataArchiveAuthMethod = reader.getString();
                    continue;
                }
                if ("preferred-data-persistence-auth-method".equals(fieldName)) {
                    deserializedRedisConfiguration.preferredDataPersistenceAuthMethod = reader.getString();
                    continue;
                }
                if ("zonal-configuration".equals(fieldName)) {
                    deserializedRedisConfiguration.zonalConfiguration = reader.getString();
                    continue;
                }
                if ("authnotrequired".equals(fieldName)) {
                    deserializedRedisConfiguration.authnotrequired = reader.getString();
                    continue;
                }
                if ("storage-subscription-id".equals(fieldName)) {
                    deserializedRedisConfiguration.storageSubscriptionId = reader.getString();
                    continue;
                }
                if ("aad-enabled".equals(fieldName)) {
                    deserializedRedisConfiguration.aadEnabled = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, String>();
                }
                additionalProperties.put(fieldName, reader.getString());
            }
            deserializedRedisConfiguration.additionalProperties = additionalProperties;
            return deserializedRedisConfiguration;
        });
    }
}

