/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.AccessPolicyAssignmentProvisioningState;
import java.io.IOException;

public final class RedisCacheAccessPolicyAssignmentProperties
implements JsonSerializable<RedisCacheAccessPolicyAssignmentProperties> {
    private AccessPolicyAssignmentProvisioningState provisioningState;
    private String objectId;
    private String objectIdAlias;
    private String accessPolicyName;
    private static final ClientLogger LOGGER = new ClientLogger(RedisCacheAccessPolicyAssignmentProperties.class);

    public AccessPolicyAssignmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String objectId() {
        return this.objectId;
    }

    public RedisCacheAccessPolicyAssignmentProperties withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    public String objectIdAlias() {
        return this.objectIdAlias;
    }

    public RedisCacheAccessPolicyAssignmentProperties withObjectIdAlias(String objectIdAlias) {
        this.objectIdAlias = objectIdAlias;
        return this;
    }

    public String accessPolicyName() {
        return this.accessPolicyName;
    }

    public RedisCacheAccessPolicyAssignmentProperties withAccessPolicyName(String accessPolicyName) {
        this.accessPolicyName = accessPolicyName;
        return this;
    }

    public void validate() {
        if (this.objectId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property objectId in model RedisCacheAccessPolicyAssignmentProperties"));
        }
        if (this.objectIdAlias() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property objectIdAlias in model RedisCacheAccessPolicyAssignmentProperties"));
        }
        if (this.accessPolicyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accessPolicyName in model RedisCacheAccessPolicyAssignmentProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectId", this.objectId);
        jsonWriter.writeStringField("objectIdAlias", this.objectIdAlias);
        jsonWriter.writeStringField("accessPolicyName", this.accessPolicyName);
        return jsonWriter.writeEndObject();
    }

    public static RedisCacheAccessPolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RedisCacheAccessPolicyAssignmentProperties)jsonReader.readObject(reader -> {
            RedisCacheAccessPolicyAssignmentProperties deserializedRedisCacheAccessPolicyAssignmentProperties = new RedisCacheAccessPolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("objectId".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.objectId = reader.getString();
                    continue;
                }
                if ("objectIdAlias".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.objectIdAlias = reader.getString();
                    continue;
                }
                if ("accessPolicyName".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.accessPolicyName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.provisioningState = AccessPolicyAssignmentProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisCacheAccessPolicyAssignmentProperties;
        });
    }
}

