/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.resourcemanager.redis.RedisManager;
import com.azure.resourcemanager.redis.fluent.models.RedisResourceInner;
import com.azure.resourcemanager.redis.models.DayOfWeek;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RebootType;
import com.azure.resourcemanager.redis.models.RedisAccessKeys;
import com.azure.resourcemanager.redis.models.RedisCachePremium;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.RedisFirewallRule;
import com.azure.resourcemanager.redis.models.RedisKeyType;
import com.azure.resourcemanager.redis.models.ScheduleEntry;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsUpdatingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public interface RedisCache
extends GroupableResource<RedisManager, RedisResourceInner>,
Refreshable<RedisCache>,
Updatable<Update>,
SupportsListingPrivateLinkResource,
SupportsListingPrivateEndpointConnection,
SupportsUpdatingPrivateEndpointConnection {
    public RedisCachePremium asPremium();

    public boolean isPremium();

    public String provisioningState();

    public String hostname();

    public int port();

    public int sslPort();

    public String redisVersion();

    public Sku sku();

    public Map<String, String> redisConfiguration();

    public boolean nonSslPort();

    public int shardCount();

    public String subnetId();

    public String staticIp();

    public TlsVersion minimumTlsVersion();

    public Map<String, RedisFirewallRule> firewallRules();

    public List<ScheduleEntry> patchSchedules();

    public void forceReboot(RebootType var1);

    public RedisAccessKeys keys();

    public RedisAccessKeys refreshKeys();

    public RedisAccessKeys regenerateKey(RedisKeyType var1);

    public PublicNetworkAccess publicNetworkAccess();

    public static enum RedisVersion {
        V6("6"),
        V4("4");

        private final String value;

        private RedisVersion(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface Update
    extends Appliable<RedisCache>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithNonSslPort,
    UpdateStages.WithRedisConfiguration,
    UpdateStages.WithPublicNetworkAccess {
        public Update withShardCount(int var1);

        public Update withPatchSchedule(DayOfWeek var1, int var2);

        public Update withPatchSchedule(DayOfWeek var1, int var2, Duration var3);

        public Update withPatchSchedule(ScheduleEntry var1);

        public Update withPatchSchedule(List<ScheduleEntry> var1);

        public Update withoutPatchSchedule();

        public Update withFirewallRule(String var1, String var2, String var3);

        public Update withFirewallRule(RedisFirewallRule var1);

        public Update withoutFirewallRule(String var1);

        public Update withMinimumTlsVersion(TlsVersion var1);

        public Update withoutMinimumTlsVersion();

        public Update withRedisVersion(RedisVersion var1);
    }

    public static interface UpdateStages {

        public static interface WithPublicNetworkAccess {
            public Update enablePublicNetworkAccess();

            public Update disablePublicNetworkAccess();
        }

        public static interface WithRedisConfiguration {
            public Update withRedisConfiguration(Map<String, String> var1);

            public Update withRedisConfiguration(String var1, String var2);

            public Update withRedisConfiguration(RedisConfiguration var1);

            public Update withoutRedisConfiguration();

            public Update withoutRedisConfiguration(String var1);
        }

        public static interface WithNonSslPort {
            public Update withNonSslPort();

            public Update withoutNonSslPort();
        }

        public static interface WithSku {
            public Update withBasicSku(int var1);

            public Update withStandardSku();

            public Update withStandardSku(int var1);

            public Update withPremiumSku();

            public Update withPremiumSku(int var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithPremiumSkuCreate
        extends WithCreate {
            public WithPremiumSkuCreate withShardCount(int var1);

            public WithCreate withSubnet(HasId var1, String var2);

            public WithCreate withSubnet(String var1);

            public WithCreate withStaticIp(String var1);
        }

        public static interface WithCreate
        extends Creatable<RedisCache>,
        Resource.DefinitionWithTags<WithCreate> {
            public WithCreate withNonSslPort();

            public WithCreate withRedisConfiguration(Map<String, String> var1);

            public WithCreate withRedisConfiguration(String var1, String var2);

            public WithCreate withRedisConfiguration(RedisConfiguration var1);

            public WithCreate withFirewallRule(String var1, String var2, String var3);

            public WithCreate withFirewallRule(RedisFirewallRule var1);

            public WithCreate withMinimumTlsVersion(TlsVersion var1);

            public WithCreate withPatchSchedule(DayOfWeek var1, int var2);

            public WithCreate withPatchSchedule(DayOfWeek var1, int var2, Duration var3);

            public WithCreate withPatchSchedule(ScheduleEntry var1);

            public WithCreate withPatchSchedule(List<ScheduleEntry> var1);

            public WithCreate withRedisVersion(RedisVersion var1);

            public WithCreate disablePublicNetworkAccess();
        }

        public static interface WithSku {
            public WithCreate withBasicSku();

            public WithCreate withBasicSku(int var1);

            public WithCreate withStandardSku();

            public WithCreate withStandardSku(int var1);

            public WithPremiumSkuCreate withPremiumSku();

            public WithPremiumSkuCreate withPremiumSku(int var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate,
    DefinitionStages.WithPremiumSkuCreate {
    }
}

