/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.azure.resourcemanager.redis.models.UpdateChannel;
import java.io.IOException;
import java.util.Map;

public class RedisCommonProperties
implements JsonSerializable<RedisCommonProperties> {
    private RedisConfiguration redisConfiguration;
    private String redisVersion;
    private Boolean enableNonSslPort;
    private Integer replicasPerMaster;
    private Integer replicasPerPrimary;
    private Map<String, String> tenantSettings;
    private Integer shardCount;
    private TlsVersion minimumTlsVersion;
    private PublicNetworkAccess publicNetworkAccess;
    private UpdateChannel updateChannel;
    private Boolean disableAccessKeyAuthentication;

    public RedisConfiguration redisConfiguration() {
        return this.redisConfiguration;
    }

    public RedisCommonProperties withRedisConfiguration(RedisConfiguration redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
        return this;
    }

    public String redisVersion() {
        return this.redisVersion;
    }

    public RedisCommonProperties withRedisVersion(String redisVersion) {
        this.redisVersion = redisVersion;
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.enableNonSslPort;
    }

    public RedisCommonProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        this.enableNonSslPort = enableNonSslPort;
        return this;
    }

    public Integer replicasPerMaster() {
        return this.replicasPerMaster;
    }

    public RedisCommonProperties withReplicasPerMaster(Integer replicasPerMaster) {
        this.replicasPerMaster = replicasPerMaster;
        return this;
    }

    public Integer replicasPerPrimary() {
        return this.replicasPerPrimary;
    }

    public RedisCommonProperties withReplicasPerPrimary(Integer replicasPerPrimary) {
        this.replicasPerPrimary = replicasPerPrimary;
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.tenantSettings;
    }

    public RedisCommonProperties withTenantSettings(Map<String, String> tenantSettings) {
        this.tenantSettings = tenantSettings;
        return this;
    }

    public Integer shardCount() {
        return this.shardCount;
    }

    public RedisCommonProperties withShardCount(Integer shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public RedisCommonProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public RedisCommonProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public UpdateChannel updateChannel() {
        return this.updateChannel;
    }

    public RedisCommonProperties withUpdateChannel(UpdateChannel updateChannel) {
        this.updateChannel = updateChannel;
        return this;
    }

    public Boolean disableAccessKeyAuthentication() {
        return this.disableAccessKeyAuthentication;
    }

    public RedisCommonProperties withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        this.disableAccessKeyAuthentication = disableAccessKeyAuthentication;
        return this;
    }

    public void validate() {
        if (this.redisConfiguration() != null) {
            this.redisConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("redisConfiguration", (JsonSerializable)this.redisConfiguration);
        jsonWriter.writeStringField("redisVersion", this.redisVersion);
        jsonWriter.writeBooleanField("enableNonSslPort", this.enableNonSslPort);
        jsonWriter.writeNumberField("replicasPerMaster", (Number)this.replicasPerMaster);
        jsonWriter.writeNumberField("replicasPerPrimary", (Number)this.replicasPerPrimary);
        jsonWriter.writeMapField("tenantSettings", this.tenantSettings, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("shardCount", (Number)this.shardCount);
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("updateChannel", this.updateChannel == null ? null : this.updateChannel.toString());
        jsonWriter.writeBooleanField("disableAccessKeyAuthentication", this.disableAccessKeyAuthentication);
        return jsonWriter.writeEndObject();
    }

    public static RedisCommonProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RedisCommonProperties)jsonReader.readObject(reader -> {
            RedisCommonProperties deserializedRedisCommonProperties = new RedisCommonProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("redisConfiguration".equals(fieldName)) {
                    deserializedRedisCommonProperties.redisConfiguration = RedisConfiguration.fromJson(reader);
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedRedisCommonProperties.redisVersion = reader.getString();
                    continue;
                }
                if ("enableNonSslPort".equals(fieldName)) {
                    deserializedRedisCommonProperties.enableNonSslPort = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("replicasPerMaster".equals(fieldName)) {
                    deserializedRedisCommonProperties.replicasPerMaster = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("replicasPerPrimary".equals(fieldName)) {
                    deserializedRedisCommonProperties.replicasPerPrimary = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("tenantSettings".equals(fieldName)) {
                    Map tenantSettings;
                    deserializedRedisCommonProperties.tenantSettings = tenantSettings = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("shardCount".equals(fieldName)) {
                    deserializedRedisCommonProperties.shardCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedRedisCommonProperties.minimumTlsVersion = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRedisCommonProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("updateChannel".equals(fieldName)) {
                    deserializedRedisCommonProperties.updateChannel = UpdateChannel.fromString(reader.getString());
                    continue;
                }
                if ("disableAccessKeyAuthentication".equals(fieldName)) {
                    deserializedRedisCommonProperties.disableAccessKeyAuthentication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisCommonProperties;
        });
    }
}

