/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RadiusServer
implements JsonSerializable<RadiusServer> {
    private String radiusServerAddress;
    private Long radiusServerScore;
    private String radiusServerSecret;
    private static final ClientLogger LOGGER = new ClientLogger(RadiusServer.class);

    public String radiusServerAddress() {
        return this.radiusServerAddress;
    }

    public RadiusServer withRadiusServerAddress(String radiusServerAddress) {
        this.radiusServerAddress = radiusServerAddress;
        return this;
    }

    public Long radiusServerScore() {
        return this.radiusServerScore;
    }

    public RadiusServer withRadiusServerScore(Long radiusServerScore) {
        this.radiusServerScore = radiusServerScore;
        return this;
    }

    public String radiusServerSecret() {
        return this.radiusServerSecret;
    }

    public RadiusServer withRadiusServerSecret(String radiusServerSecret) {
        this.radiusServerSecret = radiusServerSecret;
        return this;
    }

    public void validate() {
        if (this.radiusServerAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property radiusServerAddress in model RadiusServer"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("radiusServerAddress", this.radiusServerAddress);
        jsonWriter.writeNumberField("radiusServerScore", (Number)this.radiusServerScore);
        jsonWriter.writeStringField("radiusServerSecret", this.radiusServerSecret);
        return jsonWriter.writeEndObject();
    }

    public static RadiusServer fromJson(JsonReader jsonReader) throws IOException {
        return (RadiusServer)jsonReader.readObject(reader -> {
            RadiusServer deserializedRadiusServer = new RadiusServer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("radiusServerAddress".equals(fieldName)) {
                    deserializedRadiusServer.radiusServerAddress = reader.getString();
                    continue;
                }
                if ("radiusServerScore".equals(fieldName)) {
                    deserializedRadiusServer.radiusServerScore = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("radiusServerSecret".equals(fieldName)) {
                    deserializedRadiusServer.radiusServerSecret = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRadiusServer;
        });
    }
}

