/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.LogSpecification;
import com.azure.resourcemanager.network.models.MetricSpecification;
import java.io.IOException;
import java.util.List;

public final class OperationPropertiesFormatServiceSpecification
implements JsonSerializable<OperationPropertiesFormatServiceSpecification> {
    private List<MetricSpecification> metricSpecifications;
    private List<LogSpecification> logSpecifications;

    public List<MetricSpecification> metricSpecifications() {
        return this.metricSpecifications;
    }

    public OperationPropertiesFormatServiceSpecification withMetricSpecifications(List<MetricSpecification> metricSpecifications) {
        this.metricSpecifications = metricSpecifications;
        return this;
    }

    public List<LogSpecification> logSpecifications() {
        return this.logSpecifications;
    }

    public OperationPropertiesFormatServiceSpecification withLogSpecifications(List<LogSpecification> logSpecifications) {
        this.logSpecifications = logSpecifications;
        return this;
    }

    public void validate() {
        if (this.metricSpecifications() != null) {
            this.metricSpecifications().forEach(e -> e.validate());
        }
        if (this.logSpecifications() != null) {
            this.logSpecifications().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("metricSpecifications", this.metricSpecifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("logSpecifications", this.logSpecifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OperationPropertiesFormatServiceSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (OperationPropertiesFormatServiceSpecification)jsonReader.readObject(reader -> {
            OperationPropertiesFormatServiceSpecification deserializedOperationPropertiesFormatServiceSpecification = new OperationPropertiesFormatServiceSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metricSpecifications".equals(fieldName)) {
                    List metricSpecifications;
                    deserializedOperationPropertiesFormatServiceSpecification.metricSpecifications = metricSpecifications = reader.readArray(reader1 -> MetricSpecification.fromJson(reader1));
                    continue;
                }
                if ("logSpecifications".equals(fieldName)) {
                    List logSpecifications;
                    deserializedOperationPropertiesFormatServiceSpecification.logSpecifications = logSpecifications = reader.readArray(reader1 -> LogSpecification.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationPropertiesFormatServiceSpecification;
        });
    }
}

