/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspLinkInner;
import java.io.IOException;
import java.util.List;

public final class NspLinkListResult
implements JsonSerializable<NspLinkListResult> {
    private List<NspLinkInner> value;
    private String nextLink;

    public List<NspLinkInner> value() {
        return this.value;
    }

    public NspLinkListResult withValue(List<NspLinkInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public NspLinkListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NspLinkListResult fromJson(JsonReader jsonReader) throws IOException {
        return (NspLinkListResult)jsonReader.readObject(reader -> {
            NspLinkListResult deserializedNspLinkListResult = new NspLinkListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNspLinkListResult.value = value = reader.readArray(reader1 -> NspLinkInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNspLinkListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspLinkListResult;
        });
    }
}

