/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerInner;
import java.io.IOException;
import java.util.List;

public final class NetworkManagerListResult
implements JsonSerializable<NetworkManagerListResult> {
    private List<NetworkManagerInner> value;
    private String nextLink;

    public List<NetworkManagerInner> value() {
        return this.value;
    }

    public NetworkManagerListResult withValue(List<NetworkManagerInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public NetworkManagerListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerListResult fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerListResult)jsonReader.readObject(reader -> {
            NetworkManagerListResult deserializedNetworkManagerListResult = new NetworkManagerListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNetworkManagerListResult.value = value = reader.readArray(reader1 -> NetworkManagerInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNetworkManagerListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerListResult;
        });
    }
}

