/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConfigurationType;
import java.io.IOException;
import java.util.List;

public final class NetworkManagerDeploymentStatusParameter
implements JsonSerializable<NetworkManagerDeploymentStatusParameter> {
    private List<String> regions;
    private List<ConfigurationType> deploymentTypes;
    private String skipToken;

    public List<String> regions() {
        return this.regions;
    }

    public NetworkManagerDeploymentStatusParameter withRegions(List<String> regions) {
        this.regions = regions;
        return this;
    }

    public List<ConfigurationType> deploymentTypes() {
        return this.deploymentTypes;
    }

    public NetworkManagerDeploymentStatusParameter withDeploymentTypes(List<ConfigurationType> deploymentTypes) {
        this.deploymentTypes = deploymentTypes;
        return this;
    }

    public String skipToken() {
        return this.skipToken;
    }

    public NetworkManagerDeploymentStatusParameter withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("regions", this.regions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("deploymentTypes", this.deploymentTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("skipToken", this.skipToken);
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerDeploymentStatusParameter fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerDeploymentStatusParameter)jsonReader.readObject(reader -> {
            NetworkManagerDeploymentStatusParameter deserializedNetworkManagerDeploymentStatusParameter = new NetworkManagerDeploymentStatusParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("regions".equals(fieldName)) {
                    List regions;
                    deserializedNetworkManagerDeploymentStatusParameter.regions = regions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("deploymentTypes".equals(fieldName)) {
                    List deploymentTypes;
                    deserializedNetworkManagerDeploymentStatusParameter.deploymentTypes = deploymentTypes = reader.readArray(reader1 -> ConfigurationType.fromString(reader1.getString()));
                    continue;
                }
                if ("skipToken".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatusParameter.skipToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerDeploymentStatusParameter;
        });
    }
}

