/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExceptionEntryMatchVariable;
import com.azure.resourcemanager.network.models.ExceptionEntrySelectorMatchOperator;
import com.azure.resourcemanager.network.models.ExceptionEntryValueMatchOperator;
import com.azure.resourcemanager.network.models.ExclusionManagedRuleSet;
import java.io.IOException;
import java.util.List;

public final class ExceptionEntry
implements JsonSerializable<ExceptionEntry> {
    private ExceptionEntryMatchVariable matchVariable;
    private List<String> values;
    private ExceptionEntryValueMatchOperator valueMatchOperator;
    private ExceptionEntrySelectorMatchOperator selectorMatchOperator;
    private String selector;
    private List<ExclusionManagedRuleSet> exceptionManagedRuleSets;
    private static final ClientLogger LOGGER = new ClientLogger(ExceptionEntry.class);

    public ExceptionEntryMatchVariable matchVariable() {
        return this.matchVariable;
    }

    public ExceptionEntry withMatchVariable(ExceptionEntryMatchVariable matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public ExceptionEntry withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public ExceptionEntryValueMatchOperator valueMatchOperator() {
        return this.valueMatchOperator;
    }

    public ExceptionEntry withValueMatchOperator(ExceptionEntryValueMatchOperator valueMatchOperator) {
        this.valueMatchOperator = valueMatchOperator;
        return this;
    }

    public ExceptionEntrySelectorMatchOperator selectorMatchOperator() {
        return this.selectorMatchOperator;
    }

    public ExceptionEntry withSelectorMatchOperator(ExceptionEntrySelectorMatchOperator selectorMatchOperator) {
        this.selectorMatchOperator = selectorMatchOperator;
        return this;
    }

    public String selector() {
        return this.selector;
    }

    public ExceptionEntry withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public List<ExclusionManagedRuleSet> exceptionManagedRuleSets() {
        return this.exceptionManagedRuleSets;
    }

    public ExceptionEntry withExceptionManagedRuleSets(List<ExclusionManagedRuleSet> exceptionManagedRuleSets) {
        this.exceptionManagedRuleSets = exceptionManagedRuleSets;
        return this;
    }

    public void validate() {
        if (this.matchVariable() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property matchVariable in model ExceptionEntry"));
        }
        if (this.valueMatchOperator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property valueMatchOperator in model ExceptionEntry"));
        }
        if (this.exceptionManagedRuleSets() != null) {
            this.exceptionManagedRuleSets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("matchVariable", this.matchVariable == null ? null : this.matchVariable.toString());
        jsonWriter.writeStringField("valueMatchOperator", this.valueMatchOperator == null ? null : this.valueMatchOperator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("selectorMatchOperator", this.selectorMatchOperator == null ? null : this.selectorMatchOperator.toString());
        jsonWriter.writeStringField("selector", this.selector);
        jsonWriter.writeArrayField("exceptionManagedRuleSets", this.exceptionManagedRuleSets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExceptionEntry fromJson(JsonReader jsonReader) throws IOException {
        return (ExceptionEntry)jsonReader.readObject(reader -> {
            ExceptionEntry deserializedExceptionEntry = new ExceptionEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("matchVariable".equals(fieldName)) {
                    deserializedExceptionEntry.matchVariable = ExceptionEntryMatchVariable.fromString(reader.getString());
                    continue;
                }
                if ("valueMatchOperator".equals(fieldName)) {
                    deserializedExceptionEntry.valueMatchOperator = ExceptionEntryValueMatchOperator.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedExceptionEntry.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("selectorMatchOperator".equals(fieldName)) {
                    deserializedExceptionEntry.selectorMatchOperator = ExceptionEntrySelectorMatchOperator.fromString(reader.getString());
                    continue;
                }
                if ("selector".equals(fieldName)) {
                    deserializedExceptionEntry.selector = reader.getString();
                    continue;
                }
                if ("exceptionManagedRuleSets".equals(fieldName)) {
                    List exceptionManagedRuleSets;
                    deserializedExceptionEntry.exceptionManagedRuleSets = exceptionManagedRuleSets = reader.readArray(reader1 -> ExclusionManagedRuleSet.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExceptionEntry;
        });
    }
}

