/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpointScopeItem;
import java.io.IOException;
import java.util.List;

public final class ConnectionMonitorEndpointScope
implements JsonSerializable<ConnectionMonitorEndpointScope> {
    private List<ConnectionMonitorEndpointScopeItem> include;
    private List<ConnectionMonitorEndpointScopeItem> exclude;

    public List<ConnectionMonitorEndpointScopeItem> include() {
        return this.include;
    }

    public ConnectionMonitorEndpointScope withInclude(List<ConnectionMonitorEndpointScopeItem> include) {
        this.include = include;
        return this;
    }

    public List<ConnectionMonitorEndpointScopeItem> exclude() {
        return this.exclude;
    }

    public ConnectionMonitorEndpointScope withExclude(List<ConnectionMonitorEndpointScopeItem> exclude) {
        this.exclude = exclude;
        return this;
    }

    public void validate() {
        if (this.include() != null) {
            this.include().forEach(e -> e.validate());
        }
        if (this.exclude() != null) {
            this.exclude().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("include", this.include, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("exclude", this.exclude, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorEndpointScope fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorEndpointScope)jsonReader.readObject(reader -> {
            ConnectionMonitorEndpointScope deserializedConnectionMonitorEndpointScope = new ConnectionMonitorEndpointScope();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("include".equals(fieldName)) {
                    List include;
                    deserializedConnectionMonitorEndpointScope.include = include = reader.readArray(reader1 -> ConnectionMonitorEndpointScopeItem.fromJson(reader1));
                    continue;
                }
                if ("exclude".equals(fieldName)) {
                    List exclude;
                    deserializedConnectionMonitorEndpointScope.exclude = exclude = reader.readArray(reader1 -> ConnectionMonitorEndpointScopeItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorEndpointScope;
        });
    }
}

