/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommonResource;
import java.io.IOException;
import java.util.Map;

public class CommonTrackedResource
extends CommonResource {
    private Map<String, String> tags;
    private String location;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(CommonTrackedResource.class);

    public Map<String, String> tags() {
        return this.tags;
    }

    public CommonTrackedResource withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public CommonTrackedResource withLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model CommonTrackedResource"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CommonTrackedResource fromJson(JsonReader jsonReader) throws IOException {
        return (CommonTrackedResource)((Object)jsonReader.readObject(reader -> {
            CommonTrackedResource deserializedCommonTrackedResource = new CommonTrackedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCommonTrackedResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCommonTrackedResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCommonTrackedResource.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCommonTrackedResource.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCommonTrackedResource.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedCommonTrackedResource.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommonTrackedResource;
        }));
    }
}

