/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.BastionHostIpConfigurationPropertiesFormat;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class BastionHostIpConfiguration
extends SubResource {
    private BastionHostIpConfigurationPropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private BastionHostIpConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public BastionHostIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public BastionHostIpConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public SubResource subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public BastionHostIpConfiguration withSubnet(SubResource subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostIpConfigurationPropertiesFormat();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public SubResource publicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddress();
    }

    public BastionHostIpConfiguration withPublicIpAddress(SubResource publicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostIpConfigurationPropertiesFormat();
        }
        this.innerProperties().withPublicIpAddress(publicIpAddress);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAllocationMethod();
    }

    public BastionHostIpConfiguration withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostIpConfigurationPropertiesFormat();
        }
        this.innerProperties().withPrivateIpAllocationMethod(privateIpAllocationMethod);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static BastionHostIpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BastionHostIpConfiguration)((Object)jsonReader.readObject(reader -> {
            BastionHostIpConfiguration deserializedBastionHostIpConfiguration = new BastionHostIpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBastionHostIpConfiguration.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBastionHostIpConfiguration.innerProperties = BastionHostIpConfigurationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBastionHostIpConfiguration.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedBastionHostIpConfiguration.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBastionHostIpConfiguration.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBastionHostIpConfiguration;
        }));
    }
}

