/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyHttpHeaderToInsert;
import com.azure.resourcemanager.network.models.FirewallPolicyRule;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleApplicationProtocol;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleType;
import java.io.IOException;
import java.util.List;

public final class ApplicationRule
extends FirewallPolicyRule {
    private FirewallPolicyRuleType ruleType = FirewallPolicyRuleType.APPLICATION_RULE;
    private List<String> sourceAddresses;
    private List<String> destinationAddresses;
    private List<FirewallPolicyRuleApplicationProtocol> protocols;
    private List<String> targetFqdns;
    private List<String> targetUrls;
    private List<String> fqdnTags;
    private List<String> sourceIpGroups;
    private Boolean terminateTls;
    private List<String> webCategories;
    private List<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert;

    @Override
    public FirewallPolicyRuleType ruleType() {
        return this.ruleType;
    }

    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public ApplicationRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    public List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public ApplicationRule withDestinationAddresses(List<String> destinationAddresses) {
        this.destinationAddresses = destinationAddresses;
        return this;
    }

    public List<FirewallPolicyRuleApplicationProtocol> protocols() {
        return this.protocols;
    }

    public ApplicationRule withProtocols(List<FirewallPolicyRuleApplicationProtocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    public List<String> targetFqdns() {
        return this.targetFqdns;
    }

    public ApplicationRule withTargetFqdns(List<String> targetFqdns) {
        this.targetFqdns = targetFqdns;
        return this;
    }

    public List<String> targetUrls() {
        return this.targetUrls;
    }

    public ApplicationRule withTargetUrls(List<String> targetUrls) {
        this.targetUrls = targetUrls;
        return this;
    }

    public List<String> fqdnTags() {
        return this.fqdnTags;
    }

    public ApplicationRule withFqdnTags(List<String> fqdnTags) {
        this.fqdnTags = fqdnTags;
        return this;
    }

    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    public ApplicationRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    public Boolean terminateTls() {
        return this.terminateTls;
    }

    public ApplicationRule withTerminateTls(Boolean terminateTls) {
        this.terminateTls = terminateTls;
        return this;
    }

    public List<String> webCategories() {
        return this.webCategories;
    }

    public ApplicationRule withWebCategories(List<String> webCategories) {
        this.webCategories = webCategories;
        return this;
    }

    public List<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert() {
        return this.httpHeadersToInsert;
    }

    public ApplicationRule withHttpHeadersToInsert(List<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert) {
        this.httpHeadersToInsert = httpHeadersToInsert;
        return this;
    }

    @Override
    public ApplicationRule withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ApplicationRule withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        if (this.protocols() != null) {
            this.protocols().forEach(e -> e.validate());
        }
        if (this.httpHeadersToInsert() != null) {
            this.httpHeadersToInsert().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeArrayField("sourceAddresses", this.sourceAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationAddresses", this.destinationAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("targetFqdns", this.targetFqdns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("targetUrls", this.targetUrls, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fqdnTags", this.fqdnTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourceIpGroups", this.sourceIpGroups, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("terminateTLS", this.terminateTls);
        jsonWriter.writeArrayField("webCategories", this.webCategories, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("httpHeadersToInsert", this.httpHeadersToInsert, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationRule fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationRule)jsonReader.readObject(reader -> {
            ApplicationRule deserializedApplicationRule = new ApplicationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationRule.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedApplicationRule.withDescription(reader.getString());
                    continue;
                }
                if ("ruleType".equals(fieldName)) {
                    deserializedApplicationRule.ruleType = FirewallPolicyRuleType.fromString(reader.getString());
                    continue;
                }
                if ("sourceAddresses".equals(fieldName)) {
                    List sourceAddresses;
                    deserializedApplicationRule.sourceAddresses = sourceAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationAddresses".equals(fieldName)) {
                    List destinationAddresses;
                    deserializedApplicationRule.destinationAddresses = destinationAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("protocols".equals(fieldName)) {
                    List protocols;
                    deserializedApplicationRule.protocols = protocols = reader.readArray(reader1 -> FirewallPolicyRuleApplicationProtocol.fromJson(reader1));
                    continue;
                }
                if ("targetFqdns".equals(fieldName)) {
                    List targetFqdns;
                    deserializedApplicationRule.targetFqdns = targetFqdns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("targetUrls".equals(fieldName)) {
                    List targetUrls;
                    deserializedApplicationRule.targetUrls = targetUrls = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("fqdnTags".equals(fieldName)) {
                    List fqdnTags;
                    deserializedApplicationRule.fqdnTags = fqdnTags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sourceIpGroups".equals(fieldName)) {
                    List sourceIpGroups;
                    deserializedApplicationRule.sourceIpGroups = sourceIpGroups = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("terminateTLS".equals(fieldName)) {
                    deserializedApplicationRule.terminateTls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("webCategories".equals(fieldName)) {
                    List webCategories;
                    deserializedApplicationRule.webCategories = webCategories = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("httpHeadersToInsert".equals(fieldName)) {
                    List httpHeadersToInsert;
                    deserializedApplicationRule.httpHeadersToInsert = httpHeadersToInsert = reader.readArray(reader1 -> FirewallPolicyHttpHeaderToInsert.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationRule;
        });
    }
}

