/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewaySkuFamily;
import com.azure.resourcemanager.network.models.ApplicationGatewaySkuName;
import com.azure.resourcemanager.network.models.ApplicationGatewayTier;
import java.io.IOException;

public final class ApplicationGatewaySku
implements JsonSerializable<ApplicationGatewaySku> {
    private ApplicationGatewaySkuName name;
    private ApplicationGatewayTier tier;
    private Integer capacity;
    private ApplicationGatewaySkuFamily family;

    public ApplicationGatewaySkuName name() {
        return this.name;
    }

    public ApplicationGatewaySku withName(ApplicationGatewaySkuName name) {
        this.name = name;
        return this;
    }

    public ApplicationGatewayTier tier() {
        return this.tier;
    }

    public ApplicationGatewaySku withTier(ApplicationGatewayTier tier) {
        this.tier = tier;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public ApplicationGatewaySku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public ApplicationGatewaySkuFamily family() {
        return this.family;
    }

    public ApplicationGatewaySku withFamily(ApplicationGatewaySkuFamily family) {
        this.family = family;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewaySku fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewaySku)jsonReader.readObject(reader -> {
            ApplicationGatewaySku deserializedApplicationGatewaySku = new ApplicationGatewaySku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationGatewaySku.name = ApplicationGatewaySkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedApplicationGatewaySku.tier = ApplicationGatewayTier.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedApplicationGatewaySku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedApplicationGatewaySku.family = ApplicationGatewaySkuFamily.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewaySku;
        });
    }
}

