/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnServerConfigurationPolicyGroupMember;
import java.io.IOException;
import java.util.List;

public final class VpnServerConfigurationPolicyGroupProperties
implements JsonSerializable<VpnServerConfigurationPolicyGroupProperties> {
    private Boolean isDefault;
    private Integer priority;
    private List<VpnServerConfigurationPolicyGroupMember> policyMembers;
    private List<SubResource> p2SConnectionConfigurations;
    private ProvisioningState provisioningState;

    public Boolean isDefault() {
        return this.isDefault;
    }

    public VpnServerConfigurationPolicyGroupProperties withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public VpnServerConfigurationPolicyGroupProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public List<VpnServerConfigurationPolicyGroupMember> policyMembers() {
        return this.policyMembers;
    }

    public VpnServerConfigurationPolicyGroupProperties withPolicyMembers(List<VpnServerConfigurationPolicyGroupMember> policyMembers) {
        this.policyMembers = policyMembers;
        return this;
    }

    public List<SubResource> p2SConnectionConfigurations() {
        return this.p2SConnectionConfigurations;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.policyMembers() != null) {
            this.policyMembers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("policyMembers", this.policyMembers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VpnServerConfigurationPolicyGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VpnServerConfigurationPolicyGroupProperties)jsonReader.readObject(reader -> {
            VpnServerConfigurationPolicyGroupProperties deserializedVpnServerConfigurationPolicyGroupProperties = new VpnServerConfigurationPolicyGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isDefault".equals(fieldName)) {
                    deserializedVpnServerConfigurationPolicyGroupProperties.isDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedVpnServerConfigurationPolicyGroupProperties.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("policyMembers".equals(fieldName)) {
                    List policyMembers;
                    deserializedVpnServerConfigurationPolicyGroupProperties.policyMembers = policyMembers = reader.readArray(reader1 -> VpnServerConfigurationPolicyGroupMember.fromJson(reader1));
                    continue;
                }
                if ("p2SConnectionConfigurations".equals(fieldName)) {
                    List p2SConnectionConfigurations;
                    deserializedVpnServerConfigurationPolicyGroupProperties.p2SConnectionConfigurations = p2SConnectionConfigurations = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVpnServerConfigurationPolicyGroupProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnServerConfigurationPolicyGroupProperties;
        });
    }
}

