/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.OperationPropertiesFormat;
import com.azure.resourcemanager.network.models.OperationDisplay;
import com.azure.resourcemanager.network.models.OperationPropertiesFormatServiceSpecification;
import java.io.IOException;

public final class OperationInner
implements JsonSerializable<OperationInner> {
    private String name;
    private OperationDisplay display;
    private String origin;
    private OperationPropertiesFormat innerProperties;

    public String name() {
        return this.name;
    }

    public OperationInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    private OperationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public OperationPropertiesFormatServiceSpecification serviceSpecification() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceSpecification();
    }

    public OperationInner withServiceSpecification(OperationPropertiesFormatServiceSpecification serviceSpecification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationPropertiesFormat();
        }
        this.innerProperties().withServiceSpecification(serviceSpecification);
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationInner)jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationInner.origin = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationInner.innerProperties = OperationPropertiesFormat.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInner;
        });
    }
}

