/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspLinkProperties;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.List;

public final class NspLinkInner
extends SecurityPerimeterProxyResource {
    private NspLinkProperties innerProperties;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;

    private NspLinkProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public NspLinkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String autoApprovedRemotePerimeterResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().autoApprovedRemotePerimeterResourceId();
    }

    public NspLinkInner withAutoApprovedRemotePerimeterResourceId(String autoApprovedRemotePerimeterResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withAutoApprovedRemotePerimeterResourceId(autoApprovedRemotePerimeterResourceId);
        return this;
    }

    public String remotePerimeterGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterGuid();
    }

    public String remotePerimeterLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterLocation();
    }

    public List<String> localInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localInboundProfiles();
    }

    public NspLinkInner withLocalInboundProfiles(List<String> localInboundProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withLocalInboundProfiles(localInboundProfiles);
        return this;
    }

    public List<String> localOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localOutboundProfiles();
    }

    public List<String> remoteInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteInboundProfiles();
    }

    public NspLinkInner withRemoteInboundProfiles(List<String> remoteInboundProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withRemoteInboundProfiles(remoteInboundProfiles);
        return this;
    }

    public List<String> remoteOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteOutboundProfiles();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public NspLinkInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public NspLinkStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NspLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return (NspLinkInner)((Object)jsonReader.readObject(reader -> {
            NspLinkInner deserializedNspLinkInner = new NspLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNspLinkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNspLinkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNspLinkInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNspLinkInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNspLinkInner.innerProperties = NspLinkProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspLinkInner;
        }));
    }
}

