/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkVirtualApplianceSkuPropertiesFormat;
import com.azure.resourcemanager.network.models.NetworkVirtualApplianceSkuInstances;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NetworkVirtualApplianceSkuInner
extends Resource {
    private NetworkVirtualApplianceSkuPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private NetworkVirtualApplianceSkuPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NetworkVirtualApplianceSkuInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public NetworkVirtualApplianceSkuInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkVirtualApplianceSkuInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String vendor() {
        return this.innerProperties() == null ? null : this.innerProperties().vendor();
    }

    public List<String> availableVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().availableVersions();
    }

    public List<NetworkVirtualApplianceSkuInstances> availableScaleUnits() {
        return this.innerProperties() == null ? null : this.innerProperties().availableScaleUnits();
    }

    public NetworkVirtualApplianceSkuInner withAvailableScaleUnits(List<NetworkVirtualApplianceSkuInstances> availableScaleUnits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualApplianceSkuPropertiesFormat();
        }
        this.innerProperties().withAvailableScaleUnits(availableScaleUnits);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static NetworkVirtualApplianceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkVirtualApplianceSkuInner)((Object)jsonReader.readObject(reader -> {
            NetworkVirtualApplianceSkuInner deserializedNetworkVirtualApplianceSkuInner = new NetworkVirtualApplianceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkVirtualApplianceSkuInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.innerProperties = NetworkVirtualApplianceSkuPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkVirtualApplianceSkuInner;
        }));
    }
}

