/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayPropertiesFormat;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class LocalNetworkGatewayInner
extends Resource {
    private LocalNetworkGatewayPropertiesFormat innerProperties = new LocalNetworkGatewayPropertiesFormat();
    private String etag;
    private String id;
    private String type;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(LocalNetworkGatewayInner.class);

    private LocalNetworkGatewayPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public LocalNetworkGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public LocalNetworkGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public LocalNetworkGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AddressSpace localNetworkAddressSpace() {
        return this.innerProperties() == null ? null : this.innerProperties().localNetworkAddressSpace();
    }

    public LocalNetworkGatewayInner withLocalNetworkAddressSpace(AddressSpace localNetworkAddressSpace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withLocalNetworkAddressSpace(localNetworkAddressSpace);
        return this;
    }

    public String gatewayIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayIpAddress();
    }

    public LocalNetworkGatewayInner withGatewayIpAddress(String gatewayIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withGatewayIpAddress(gatewayIpAddress);
        return this;
    }

    public String fqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdn();
    }

    public LocalNetworkGatewayInner withFqdn(String fqdn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withFqdn(fqdn);
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpSettings();
    }

    public LocalNetworkGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withBgpSettings(bgpSettings);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model LocalNetworkGatewayInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static LocalNetworkGatewayInner fromJson(JsonReader jsonReader) throws IOException {
        return (LocalNetworkGatewayInner)((Object)jsonReader.readObject(reader -> {
            LocalNetworkGatewayInner deserializedLocalNetworkGatewayInner = new LocalNetworkGatewayInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLocalNetworkGatewayInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLocalNetworkGatewayInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedLocalNetworkGatewayInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedLocalNetworkGatewayInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLocalNetworkGatewayInner.innerProperties = LocalNetworkGatewayPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedLocalNetworkGatewayInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedLocalNetworkGatewayInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocalNetworkGatewayInner;
        }));
    }
}

