/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteProviderPortProperties;
import java.io.IOException;
import java.util.Map;

public final class ExpressRouteProviderPortInner
extends Resource {
    private ExpressRouteProviderPortProperties innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private ExpressRouteProviderPortProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteProviderPortInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public ExpressRouteProviderPortInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRouteProviderPortInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String portPairDescriptor() {
        return this.innerProperties() == null ? null : this.innerProperties().portPairDescriptor();
    }

    public String primaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAzurePort();
    }

    public String secondaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryAzurePort();
    }

    public String peeringLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocation();
    }

    public ExpressRouteProviderPortInner withPeeringLocation(String peeringLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withPeeringLocation(peeringLocation);
        return this;
    }

    public Integer overprovisionFactor() {
        return this.innerProperties() == null ? null : this.innerProperties().overprovisionFactor();
    }

    public ExpressRouteProviderPortInner withOverprovisionFactor(Integer overprovisionFactor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withOverprovisionFactor(overprovisionFactor);
        return this;
    }

    public Integer portBandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().portBandwidthInMbps();
    }

    public ExpressRouteProviderPortInner withPortBandwidthInMbps(Integer portBandwidthInMbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withPortBandwidthInMbps(portBandwidthInMbps);
        return this;
    }

    public Integer usedBandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().usedBandwidthInMbps();
    }

    public ExpressRouteProviderPortInner withUsedBandwidthInMbps(Integer usedBandwidthInMbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withUsedBandwidthInMbps(usedBandwidthInMbps);
        return this;
    }

    public Integer remainingBandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().remainingBandwidthInMbps();
    }

    public ExpressRouteProviderPortInner withRemainingBandwidthInMbps(Integer remainingBandwidthInMbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withRemainingBandwidthInMbps(remainingBandwidthInMbps);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteProviderPortInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteProviderPortInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteProviderPortInner deserializedExpressRouteProviderPortInner = new ExpressRouteProviderPortInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteProviderPortInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteProviderPortInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRouteProviderPortInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRouteProviderPortInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteProviderPortInner.innerProperties = ExpressRouteProviderPortProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteProviderPortInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteProviderPortInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteProviderPortInner;
        }));
    }
}

