/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class ApplicationSecurityGroupInner
extends Resource {
    private ApplicationSecurityGroupPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private ApplicationSecurityGroupPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public ApplicationSecurityGroupInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public ApplicationSecurityGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ApplicationSecurityGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationSecurityGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationSecurityGroupInner)((Object)jsonReader.readObject(reader -> {
            ApplicationSecurityGroupInner deserializedApplicationSecurityGroupInner = new ApplicationSecurityGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationSecurityGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationSecurityGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedApplicationSecurityGroupInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApplicationSecurityGroupInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationSecurityGroupInner.innerProperties = ApplicationSecurityGroupPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApplicationSecurityGroupInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedApplicationSecurityGroupInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationSecurityGroupInner;
        }));
    }
}

