/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RoutingPolicy
implements JsonSerializable<RoutingPolicy> {
    private String name;
    private List<String> destinations;
    private String nextHop;
    private static final ClientLogger LOGGER = new ClientLogger(RoutingPolicy.class);

    public String name() {
        return this.name;
    }

    public RoutingPolicy withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> destinations() {
        return this.destinations;
    }

    public RoutingPolicy withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    public String nextHop() {
        return this.nextHop;
    }

    public RoutingPolicy withNextHop(String nextHop) {
        this.nextHop = nextHop;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model RoutingPolicy"));
        }
        if (this.destinations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinations in model RoutingPolicy"));
        }
        if (this.nextHop() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nextHop in model RoutingPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("nextHop", this.nextHop);
        return jsonWriter.writeEndObject();
    }

    public static RoutingPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingPolicy)jsonReader.readObject(reader -> {
            RoutingPolicy deserializedRoutingPolicy = new RoutingPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRoutingPolicy.name = reader.getString();
                    continue;
                }
                if ("destinations".equals(fieldName)) {
                    List destinations;
                    deserializedRoutingPolicy.destinations = destinations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("nextHop".equals(fieldName)) {
                    deserializedRoutingPolicy.nextHop = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingPolicy;
        });
    }
}

