/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceConnectionProperties;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class PrivateLinkServiceConnection
extends SubResource {
    private PrivateLinkServiceConnectionProperties innerProperties;
    private String name;
    private String type;
    private String etag;

    private PrivateLinkServiceConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public PrivateLinkServiceConnection withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public PrivateLinkServiceConnection withId(String id) {
        super.withId(id);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String privateLinkServiceId() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceId();
    }

    public PrivateLinkServiceConnection withPrivateLinkServiceId(String privateLinkServiceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceId(privateLinkServiceId);
        return this;
    }

    public List<String> groupIds() {
        return this.innerProperties() == null ? null : this.innerProperties().groupIds();
    }

    public PrivateLinkServiceConnection withGroupIds(List<String> groupIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withGroupIds(groupIds);
        return this;
    }

    public String requestMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().requestMessage();
    }

    public PrivateLinkServiceConnection withRequestMessage(String requestMessage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withRequestMessage(requestMessage);
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public PrivateLinkServiceConnection withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkServiceConnection fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkServiceConnection)((Object)jsonReader.readObject(reader -> {
            PrivateLinkServiceConnection deserializedPrivateLinkServiceConnection = new PrivateLinkServiceConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnection.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnection.innerProperties = PrivateLinkServiceConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnection.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnection.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnection.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkServiceConnection;
        }));
    }
}

