/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ErrorAdditionalInfo;
import java.io.IOException;
import java.util.List;

public final class ErrorDetail
implements JsonSerializable<ErrorDetail> {
    private String code;
    private String message;
    private String target;
    private List<ErrorDetail> details;
    private List<ErrorAdditionalInfo> additionalInfo;

    public String code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public String target() {
        return this.target;
    }

    public List<ErrorDetail> details() {
        return this.details;
    }

    public List<ErrorAdditionalInfo> additionalInfo() {
        return this.additionalInfo;
    }

    public void validate() {
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
        if (this.additionalInfo() != null) {
            this.additionalInfo().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ErrorDetail fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorDetail)jsonReader.readObject(reader -> {
            ErrorDetail deserializedErrorDetail = new ErrorDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedErrorDetail.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedErrorDetail.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedErrorDetail.target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedErrorDetail.details = details = reader.readArray(reader1 -> ErrorDetail.fromJson(reader1));
                    continue;
                }
                if ("additionalInfo".equals(fieldName)) {
                    List additionalInfo;
                    deserializedErrorDetail.additionalInfo = additionalInfo = reader.readArray(reader1 -> ErrorAdditionalInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedErrorDetail;
        });
    }
}

