/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ConnectivityConfigurationInner;
import java.io.IOException;
import java.util.List;

public final class ConnectivityConfigurationListResult
implements JsonSerializable<ConnectivityConfigurationListResult> {
    private List<ConnectivityConfigurationInner> value;
    private String nextLink;

    public List<ConnectivityConfigurationInner> value() {
        return this.value;
    }

    public ConnectivityConfigurationListResult withValue(List<ConnectivityConfigurationInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ConnectivityConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityConfigurationListResult)jsonReader.readObject(reader -> {
            ConnectivityConfigurationListResult deserializedConnectivityConfigurationListResult = new ConnectivityConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedConnectivityConfigurationListResult.value = value = reader.readArray(reader1 -> ConnectivityConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedConnectivityConfigurationListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityConfigurationListResult;
        });
    }
}

