/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ConnectionMonitorTestGroup
implements JsonSerializable<ConnectionMonitorTestGroup> {
    private String name;
    private Boolean disable;
    private List<String> testConfigurations;
    private List<String> sources;
    private List<String> destinations;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionMonitorTestGroup.class);

    public String name() {
        return this.name;
    }

    public ConnectionMonitorTestGroup withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean disable() {
        return this.disable;
    }

    public ConnectionMonitorTestGroup withDisable(Boolean disable) {
        this.disable = disable;
        return this;
    }

    public List<String> testConfigurations() {
        return this.testConfigurations;
    }

    public ConnectionMonitorTestGroup withTestConfigurations(List<String> testConfigurations) {
        this.testConfigurations = testConfigurations;
        return this;
    }

    public List<String> sources() {
        return this.sources;
    }

    public ConnectionMonitorTestGroup withSources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public List<String> destinations() {
        return this.destinations;
    }

    public ConnectionMonitorTestGroup withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ConnectionMonitorTestGroup"));
        }
        if (this.testConfigurations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property testConfigurations in model ConnectionMonitorTestGroup"));
        }
        if (this.sources() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sources in model ConnectionMonitorTestGroup"));
        }
        if (this.destinations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinations in model ConnectionMonitorTestGroup"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("testConfigurations", this.testConfigurations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sources", this.sources, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("disable", this.disable);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorTestGroup fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorTestGroup)jsonReader.readObject(reader -> {
            ConnectionMonitorTestGroup deserializedConnectionMonitorTestGroup = new ConnectionMonitorTestGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnectionMonitorTestGroup.name = reader.getString();
                    continue;
                }
                if ("testConfigurations".equals(fieldName)) {
                    List testConfigurations;
                    deserializedConnectionMonitorTestGroup.testConfigurations = testConfigurations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sources".equals(fieldName)) {
                    List sources;
                    deserializedConnectionMonitorTestGroup.sources = sources = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinations".equals(fieldName)) {
                    List destinations;
                    deserializedConnectionMonitorTestGroup.destinations = destinations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disable".equals(fieldName)) {
                    deserializedConnectionMonitorTestGroup.disable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorTestGroup;
        });
    }
}

