/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ReachabilityAnalysisRunsClient;
import com.azure.resourcemanager.network.fluent.models.ReachabilityAnalysisRunInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ReachabilityAnalysisRunListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReachabilityAnalysisRunsClientImpl
implements ReachabilityAnalysisRunsClient {
    private final ReachabilityAnalysisRunsService service;
    private final NetworkManagementClientImpl client;

    ReachabilityAnalysisRunsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ReachabilityAnalysisRunsService)RestProxy.create(ReachabilityAnalysisRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisRunInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisRunListResult)res.getValue()).value(), ((ReachabilityAnalysisRunListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisRunInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisRunListResult)res.getValue()).value(), ((ReachabilityAnalysisRunListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ReachabilityAnalysisRunInner> listAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ReachabilityAnalysisRunInner> listAsync(String resourceGroupName, String networkManagerName, String workspaceName) {
        String skipToken = null;
        Integer skip = null;
        Integer top = null;
        String sortKey = null;
        String sortValue = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ReachabilityAnalysisRunInner> listAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ReachabilityAnalysisRunInner> list(String resourceGroupName, String networkManagerName, String workspaceName) {
        String skipToken = null;
        Integer skip = null;
        Integer top = null;
        String sortKey = null;
        String sortValue = null;
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ReachabilityAnalysisRunInner> list(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReachabilityAnalysisRunInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisRunName is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ReachabilityAnalysisRunInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisRunName is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReachabilityAnalysisRunInner> getAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ReachabilityAnalysisRunInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReachabilityAnalysisRunInner> getWithResponse(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReachabilityAnalysisRunInner get(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        return (ReachabilityAnalysisRunInner)((Object)this.getWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReachabilityAnalysisRunInner>> createWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, ReachabilityAnalysisRunInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisRunName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ReachabilityAnalysisRunInner>> createWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, ReachabilityAnalysisRunInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisRunName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReachabilityAnalysisRunInner> createAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, ReachabilityAnalysisRunInner body) {
        return this.createWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, body).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ReachabilityAnalysisRunInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReachabilityAnalysisRunInner> createWithResponse(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, ReachabilityAnalysisRunInner body, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReachabilityAnalysisRunInner create(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, ReachabilityAnalysisRunInner body) {
        return (ReachabilityAnalysisRunInner)((Object)this.createWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, body, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisRunName is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisRunName is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2024-07-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName) {
        this.deleteAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisRunName, Context context) {
        this.deleteAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisRunName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisRunInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisRunListResult)res.getValue()).value(), ((ReachabilityAnalysisRunListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisRunInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisRunListResult)res.getValue()).value(), ((ReachabilityAnalysisRunListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface ReachabilityAnalysisRunsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisRuns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisRunListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @QueryParam(value="skipToken") String var7, @QueryParam(value="skip") Integer var8, @QueryParam(value="top") Integer var9, @QueryParam(value="sortKey") String var10, @QueryParam(value="sortValue") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisRuns/{reachabilityAnalysisRunName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisRunInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="reachabilityAnalysisRunName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisRuns/{reachabilityAnalysisRunName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisRunInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="reachabilityAnalysisRunName") String var7, @BodyParam(value="application/json") ReachabilityAnalysisRunInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisRuns/{reachabilityAnalysisRunName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="reachabilityAnalysisRunName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisRunListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

