/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceTapConfigurationInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class VirtualNetworkTapPropertiesFormatInner
implements JsonSerializable<VirtualNetworkTapPropertiesFormatInner> {
    private List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration;
    private FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration;
    private Integer destinationPort;

    public List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations() {
        return this.networkInterfaceTapConfigurations;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration() {
        return this.destinationNetworkInterfaceIpConfiguration;
    }

    public VirtualNetworkTapPropertiesFormatInner withDestinationNetworkInterfaceIpConfiguration(NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration) {
        this.destinationNetworkInterfaceIpConfiguration = destinationNetworkInterfaceIpConfiguration;
        return this;
    }

    public FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration() {
        return this.destinationLoadBalancerFrontEndIpConfiguration;
    }

    public VirtualNetworkTapPropertiesFormatInner withDestinationLoadBalancerFrontEndIpConfiguration(FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration) {
        this.destinationLoadBalancerFrontEndIpConfiguration = destinationLoadBalancerFrontEndIpConfiguration;
        return this;
    }

    public Integer destinationPort() {
        return this.destinationPort;
    }

    public VirtualNetworkTapPropertiesFormatInner withDestinationPort(Integer destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    public void validate() {
        if (this.networkInterfaceTapConfigurations() != null) {
            this.networkInterfaceTapConfigurations().forEach(e -> e.validate());
        }
        if (this.destinationNetworkInterfaceIpConfiguration() != null) {
            this.destinationNetworkInterfaceIpConfiguration().validate();
        }
        if (this.destinationLoadBalancerFrontEndIpConfiguration() != null) {
            this.destinationLoadBalancerFrontEndIpConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destinationNetworkInterfaceIPConfiguration", (JsonSerializable)this.destinationNetworkInterfaceIpConfiguration);
        jsonWriter.writeJsonField("destinationLoadBalancerFrontEndIPConfiguration", (JsonSerializable)this.destinationLoadBalancerFrontEndIpConfiguration);
        jsonWriter.writeNumberField("destinationPort", (Number)this.destinationPort);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkTapPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkTapPropertiesFormatInner)jsonReader.readObject(reader -> {
            VirtualNetworkTapPropertiesFormatInner deserializedVirtualNetworkTapPropertiesFormatInner = new VirtualNetworkTapPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkInterfaceTapConfigurations".equals(fieldName)) {
                    List networkInterfaceTapConfigurations;
                    deserializedVirtualNetworkTapPropertiesFormatInner.networkInterfaceTapConfigurations = networkInterfaceTapConfigurations = reader.readArray(reader1 -> NetworkInterfaceTapConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("destinationNetworkInterfaceIPConfiguration".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.destinationNetworkInterfaceIpConfiguration = NetworkInterfaceIpConfigurationInner.fromJson(reader);
                    continue;
                }
                if ("destinationLoadBalancerFrontEndIPConfiguration".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.destinationLoadBalancerFrontEndIpConfiguration = FrontendIpConfigurationInner.fromJson(reader);
                    continue;
                }
                if ("destinationPort".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.destinationPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkTapPropertiesFormatInner;
        });
    }
}

